/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.spellcard;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ListSpellCard
extends SpellCard {
    @SerialClass.SerialField
    public final ArrayList<ActualSpellCard> list = new ArrayList();
    @SerialClass.SerialField
    public int index;
    @SerialClass.SerialField
    public int health = 20;

    public static ListSpellCard of(ActualSpellCard ... cards) {
        ListSpellCard ans = new ListSpellCard();
        ans.list.addAll(Arrays.asList(cards));
        return ans;
    }

    public ActualSpellCard card() {
        return this.list.get(this.index);
    }

    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        if (this.card().hit >= this.health) {
            ++this.index;
            if (this.index == this.list.size()) {
                this.index = 0;
            }
            this.card().reset();
        }
        this.card().tick(holder);
    }

    @Override
    public ProjectileMovement move(int code, int tickCount, Vec3 vec) {
        return this.card().move(code, tickCount, vec);
    }

    @Override
    public void hurt(CardHolder holder, DamageSource source, float amount) {
        super.hurt(holder, source, amount);
        this.card().hurt(holder, source, amount);
    }

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        return this.card().getDanmakuDamageSource(danmaku);
    }

    @Override
    public void reset() {
        super.reset();
        for (ActualSpellCard e : this.list) {
            e.reset();
        }
        this.index = 0;
    }
}

