/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.player;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.content.spell.mover.CompositeMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.ZeroMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class MystiaItemSpell
extends ItemSpell {
    @Override
    public void start(Player player, @Nullable LivingEntity target) {
        super.start(player, target);
        this.addTicker(new SweepLarge(player.m_217043_().m_188499_() ? -1 : 1));
    }

    @SerialClass
    public static class SweepLarge
    extends Ticker<MystiaItemSpell> {
        @SerialClass.SerialField
        private Vec3 dir;
        @SerialClass.SerialField
        private int rot;

        public SweepLarge() {
        }

        public SweepLarge(int rot) {
            this.rot = rot;
        }

        @Override
        public boolean tick(CardHolder holder, MystiaItemSpell card) {
            if (this.dir == null) {
                this.dir = holder.forward().m_82541_();
            }
            int n = 15;
            int dt = 2;
            int dy = 3;
            if (this.tick % dt == 0) {
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir);
                for (int i = 0; i < dy; ++i) {
                    double index = (double)this.rot * (1.0 * (double)this.tick / (double)dt - ((double)n - 0.5) / 2.0);
                    Vec3 vec = o.rotateDegrees(index * 10.0, ((double)i - ((double)dy - 0.5) / 2.0) * 10.0);
                    for (int j = 0; j < 10; ++j) {
                        int t0 = 15 - j / 2;
                        int t1 = 30 - j - t0;
                        double speed = 1.6;
                        ItemDanmakuEntity e = holder.prepareDanmaku(80, vec, YHDanmaku.Bullet.MENTOS, DyeColor.LIME);
                        CompositeMover mover = new CompositeMover();
                        mover.add(j + 1, new ZeroMover(vec, vec, j + 1));
                        Vec3 p0 = holder.center();
                        Vec3 v = vec.m_82490_(speed);
                        Vec3 a = vec.m_82490_(-speed / (double)t0);
                        mover.add(t0, new RectMover(p0, v, a));
                        Vec3 p1 = p0.m_82549_(v.m_82490_((double)t0 * 0.5));
                        mover.add(t1, new ZeroMover(vec, vec, t1));
                        mover.add(20, new RectMover(p1, Vec3.f_82478_, vec.m_82490_(speed / 10.0)));
                        mover.addEnd();
                        e.mover = mover;
                        holder.shoot(e);
                    }
                }
            }
            super.tick(holder, card);
            return this.tick >= n * dt;
        }
    }
}

