/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.player;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.TrailAction;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ClownItemSpell
extends ItemSpell {
    private static final int DUR = 60;
    private int tick = 0;

    @Override
    public boolean tick(Player player) {
        int kind;
        RandomSource rand = player.m_217043_();
        if (this.tick == 0 || this.tick == 60) {
            kind = this.tick / 60 % 2;
            if (kind == 0) {
                int sign = rand.m_188499_() ? 1 : -1;
                DanmakuHelper.Orientation nor = DanmakuHelper.getOrientation(this.dir).asNormal();
                double ver = rand.m_188500_() * 20.0;
                for (int i = 0; i < 3; ++i) {
                    Vec3 n0 = nor.rotateDegrees(ver * (double)sign);
                    Vec3 n1 = nor.rotateDegrees(-ver * (double)sign);
                    this.addTicker(new Laser().init(this.dir, n0, 20, 1, kind).setTime(i * -10));
                    this.addTicker(new Laser().init(this.dir, n1, 20, -1, kind).setTime(i * -10));
                    ver += 30.0;
                }
            } else {
                double ver = (rand.m_188500_() * 2.0 - 1.0) * 60.0;
                DanmakuHelper.Orientation nor = DanmakuHelper.getOrientation(this.dir).asNormal();
                Vec3 n0 = nor.rotateDegrees(ver);
                Vec3 n1 = nor.rotateDegrees(-ver);
                this.addTicker(new Laser().init(this.dir, n0, 20, 1, kind));
                this.addTicker(new Laser().init(this.dir, n1, 20, -1, kind));
            }
        }
        if (this.tick % 10 == 0) {
            kind = this.tick / 60 % 2;
            int round = this.tick / 10;
            if (this.tick % 60 / 10 < 4) {
                DyeColor col = kind == 0 ? DyeColor.RED : DyeColor.BLUE;
                YHDanmaku.Bullet type = kind == 0 ? YHDanmaku.Bullet.STAR : YHDanmaku.Bullet.SPARK;
                this.addTicker(new Spread().init(col, type, this.dir, round % 2 == 0 ? 9.0 : -9.0, 0.8, 10));
            }
        }
        ++this.tick;
        return this.tick > 60 & super.tick(player);
    }

    @SerialClass
    public static class Laser
    extends Ticker<ClownItemSpell> {
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);
        @SerialClass.SerialField
        private Vec3 nor = new Vec3(0.0, 1.0, 0.0);
        @SerialClass.SerialField
        private int dur;
        @SerialClass.SerialField
        private int s;
        @SerialClass.SerialField
        private int type;

        public Laser init(Vec3 dir, Vec3 nor, int dur, int s, int type) {
            this.dir = dir;
            this.nor = nor;
            this.dur = dur;
            this.s = s;
            this.type = type;
            return this;
        }

        public Laser setTime(int time) {
            this.tick = time;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, ClownItemSpell card) {
            super.tick(holder, card);
            if (this.tick == 0) {
                this.dir = holder.forward();
            }
            if (this.tick > 0) {
                double angle = (45.0 + 1.0 * (double)this.tick / (double)this.dur * 180.0) * (double)this.s;
                double forward = (-45.0 + 1.0 * (double)this.tick / (double)this.dur * 90.0) * (double)this.s;
                double ver = (-15.0 + 1.0 * (double)this.tick / (double)this.dur * 30.0) * (double)this.s;
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir, this.nor);
                Vec3 dir = o.rotateDegrees(angle);
                DyeColor col = this.type == 0 ? DyeColor.BLUE : DyeColor.RED;
                ItemDanmakuEntity e = holder.prepareDanmaku(5 + this.tick * 2, dir.m_82490_(0.5), YHDanmaku.Bullet.MENTOS, col);
                e.afterExpiry = this.type == 0 ? new SpreadTrail().init(o.rotateDegrees(forward, ver)) : new HomingTrail();
                holder.shoot(e);
            }
            return this.tick > this.dur;
        }
    }

    @SerialClass
    public static class Spread
    extends Ticker<ClownItemSpell> {
        @SerialClass.SerialField
        private DyeColor color = DyeColor.RED;
        @SerialClass.SerialField
        private YHDanmaku.Bullet type = YHDanmaku.Bullet.BALL;
        @SerialClass.SerialField
        private double w = 3.0;
        @SerialClass.SerialField
        private double v = 0.5;
        @SerialClass.SerialField
        private int duration;
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);

        public Spread init(DyeColor color, YHDanmaku.Bullet type, Vec3 dir, double w, double v, int duration) {
            this.color = color;
            this.type = type;
            this.dir = dir;
            this.w = w;
            this.v = v;
            this.duration = duration;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, ClownItemSpell card) {
            RandomSource r = holder.random();
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir);
            int n = 3;
            Vec3 cen = holder.center();
            for (int i = 0; i < n; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    double hor = ((double)this.tick - (double)this.duration / 2.0 + 1.0 * (double)i / (double)n + r.m_188500_() / (double)n) * this.w;
                    double ver = r.m_216339_(-3, 3) + j * 15;
                    Vec3 dir = o.rotateDegrees(hor, ver);
                    Vec3 vel = dir.m_82490_(this.v);
                    int life = (int)(40.0 / this.v * (1.0 + r.m_188500_() * 0.5));
                    ItemDanmakuEntity e = holder.prepareDanmaku(life, vel, this.type, this.color);
                    e.m_146884_(cen.m_82549_(vel.m_82490_(1.0 * (double)i / (double)n)));
                    holder.shoot(e);
                }
            }
            super.tick(holder, card);
            return this.tick >= this.duration;
        }
    }

    @SerialClass
    public static class HomingTrail
    extends TrailAction {
        @Override
        public void execute(CardHolder holder, Vec3 pos, Vec3 dir) {
            Vec3 target = holder.target();
            if (target == null) {
                return;
            }
            Vec3 forward = target.m_82546_(pos).m_82541_();
            ItemLaserEntity e = holder.prepareLaser(60, pos, forward, 60.0f, YHDanmaku.Laser.LASER, DyeColor.RED);
            e.setupTime(10, 10, 60, 10);
            holder.shoot(e);
            ItemDanmakuEntity b = holder.prepareDanmaku(80, Vec3.f_82478_, YHDanmaku.Bullet.MENTOS, DyeColor.RED);
            b.m_146884_(pos);
            holder.shoot(b);
        }
    }

    @SerialClass
    public static class SpreadTrail
    extends TrailAction {
        @SerialClass.SerialField
        private Vec3 forward = new Vec3(1.0, 0.0, 0.0);

        public SpreadTrail init(Vec3 dir) {
            this.forward = dir;
            return this;
        }

        @Override
        public void execute(CardHolder holder, Vec3 pos, Vec3 dir) {
            ItemLaserEntity e = holder.prepareLaser(60, pos, this.forward, 60.0f, YHDanmaku.Laser.LASER, DyeColor.BLUE);
            e.setupTime(10, 10, 60, 10);
            holder.shoot(e);
            ItemDanmakuEntity b = holder.prepareDanmaku(80, Vec3.f_82478_, YHDanmaku.Bullet.MENTOS, DyeColor.BLUE);
            b.m_146884_(pos);
            holder.shoot(b);
        }
    }
}

