/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.item;

import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2library.capability.conditionals.ConditionalToken;
import dev.xkmc.l2library.capability.conditionals.Context;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2library.capability.conditionals.TokenProvider;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.spell.item.ItemSpell;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class SpellContainer
extends ConditionalToken {
    private static final TokenKey<SpellContainer> SPELL = TokenKey.of((ResourceLocation)YoukaisHomecoming.loc("spellcards"));
    private static final Provider PVD = new Provider();
    @SerialClass.SerialField
    private final List<ItemSpell> spells = new LinkedList<ItemSpell>();
    private final List<SimplifiedProjectile> cache = new LinkedList<SimplifiedProjectile>();

    public static void clear(ServerPlayer sp) {
        SpellContainer data = (SpellContainer)((ConditionalData)ConditionalData.HOLDER.get((Player)sp)).getOrCreateData((TokenProvider)PVD, (Context)PVD);
        for (ItemSpell spell : data.spells) {
            for (SimplifiedProjectile e : spell.cache) {
                e.markErased(true);
            }
        }
        for (SimplifiedProjectile e : data.cache) {
            e.markErased(true);
        }
        data.cache.clear();
        data.spells.clear();
    }

    public static void track(ServerPlayer sp, SimplifiedProjectile e) {
        SpellContainer data = (SpellContainer)((ConditionalData)ConditionalData.HOLDER.get((Player)sp)).getOrCreateData((TokenProvider)PVD, (Context)PVD);
        data.cache.add(e);
    }

    public static void castSpell(ServerPlayer sp, Supplier<? extends ItemSpell> sup, @Nullable LivingEntity target) {
        ItemSpell spell = sup.get();
        spell.start((Player)sp, target);
        ((SpellContainer)((ConditionalData)ConditionalData.HOLDER.get((Player)sp)).getOrCreateData((TokenProvider)SpellContainer.PVD, (Context)SpellContainer.PVD)).spells.add(spell);
    }

    public boolean tick(Player player) {
        Iterator<ItemSpell> itr = this.spells.iterator();
        while (itr.hasNext()) {
            ItemSpell spell = itr.next();
            boolean remove = spell.tick(player);
            if (!remove) continue;
            itr.remove();
            this.cache.addAll(spell.cache);
        }
        this.cache.removeIf(e -> !e.isValid());
        return this.spells.isEmpty() && this.cache.isEmpty();
    }

    private record Provider() implements TokenProvider<SpellContainer, Provider>,
    Context
    {
        public SpellContainer getData(Provider provider) {
            return new SpellContainer();
        }

        public TokenKey<SpellContainer> getKey() {
            return SPELL;
        }
    }
}

