/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.reimu.ReimuEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.TargetTracker;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.TrailAction;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ReimuSpell
extends ActualSpellCard {
    @SerialClass.SerialField
    private boolean border;
    @SerialClass.SerialField
    private TargetTracker tracker = new TargetTracker();

    @Override
    public void tick(CardHolder holder) {
        Vec3 target;
        LivingEntity livingEntity;
        super.tick(holder);
        int interval = 10;
        if (this.tick > 2400 && (livingEntity = holder.self()) instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)livingEntity;
            youkai.setFlag(4, true);
        }
        if ((target = holder.target()) == null) {
            return;
        }
        this.tracker.tick(this.tick, holder);
        double dist = holder.center().m_82554_(target);
        if (this.tick % interval == 0) {
            int step = this.tick / interval % 5;
            if (step < 3) {
                this.shoot(holder, dist);
            } else if (dist > 40.0) {
                this.intercept(holder, target);
            } else if (step == 3 && this.isAbyss(holder) && this.tracker.flyTime() > 20) {
                Vec3 dir = target.m_82546_(holder.center()).m_82541_();
                Vec3 ori = DanmakuHelper.getOrientation(dir).rotateDegrees(holder.random().m_188500_() * 120.0 + 30.0, 0.0);
                Vec3 sec = DanmakuHelper.getOrientation(ori).rotateDegrees(90.0, holder.random().m_188500_() * 120.0 - 60.0);
                this.sequence(holder, dist, ori, sec, 10.0, -0.6, 1, 5, 10, 2.0, YHDanmaku.Bullet.BALL);
            }
        }
        if (this.border) {
            this.border(holder, dist);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.border = false;
        this.tracker = new TargetTracker();
    }

    private void setAbyss(CardHolder holder) {
        LivingEntity livingEntity = holder.self();
        if (livingEntity instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)livingEntity;
            youkai.setFlag(4, true);
        }
    }

    private boolean isAbyss(CardHolder holder) {
        ReimuEntity e;
        LivingEntity livingEntity = holder.self();
        return livingEntity instanceof ReimuEntity && (e = (ReimuEntity)livingEntity).isAbyssal();
    }

    private void shoot(CardHolder holder, double dist) {
        Vec3 target = holder.target();
        Vec3 vel = this.tracker.vel();
        if (target == null) {
            return;
        }
        StateChange ans = new StateChange();
        double perc = Mth.m_14008_((double)((dist - 16.0) / 24.0), (double)0.0, (double)1.0);
        ans.r0 = (int)Mth.m_14139_((double)perc, (double)6.0, (double)20.0);
        ans.r1 = (int)Mth.m_14139_((double)perc, (double)6.0, (double)20.0);
        ans.t0 = (int)Mth.m_14139_((double)perc, (double)20.0, (double)10.0);
        ans.t1 = (int)Mth.m_14139_((double)perc, (double)20.0, (double)10.0);
        ans.termSpeed = (int)Mth.m_14139_((double)perc, (double)1.0, (double)3.0);
        if (this.isAbyss(holder)) {
            ans.color = DyeColor.BLUE;
        }
        Vec3 diff = target.m_82546_(holder.center());
        RandomSource r = holder.random();
        ans.pos = holder.center();
        if (Math.abs(diff.f_82480_) > 6.0 && vel.m_82553_() > 0.2) {
            Vec3 a = diff.m_82541_();
            Vec3 b = diff.m_82549_(vel.m_82490_(20.0)).m_82541_();
            Vec3 c = a.m_82537_(b).m_82541_();
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(a, c);
            ans.init = ori.rotateDegrees(90.0, r.m_188500_() * 360.0);
            ans.normal = a.m_82537_(ans.init);
        } else {
            Vec3 dir = diff.m_82541_();
            double tilt = 60.0 * r.m_188500_() - 30.0;
            ans.init = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, tilt);
            ans.normal = dir.m_82537_(ans.init);
        }
        this.addTicker(ans);
    }

    private void intercept(CardHolder holder, Vec3 target) {
        Vec3 dir = holder.targetVelocity();
        if (dir == null) {
            return;
        }
        double speed = dir.m_82553_();
        if ((dir = dir.m_82541_()).m_82553_() < 0.1) {
            return;
        }
        double dist = Math.max(24.0, speed * 20.0);
        Vec3 dst = target.m_82549_(dir.m_82490_(dist));
        if (dst.f_82480_ < (double)holder.self().m_9236_().m_141937_()) {
            dst = new Vec3(dst.f_82479_, target.f_82480_, dst.f_82481_);
        }
        if (!ReimuSpell.teleport(holder.self(), dst)) {
            return;
        }
        if (speed < 0.5) {
            return;
        }
        Intercept ans = new Intercept();
        ans.vec = target;
        ans.dir = dir;
        this.addTicker(ans);
    }

    private void border(CardHolder holder, double dist) {
        Vec3 forward = holder.forward();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(forward);
        double angle = ProjectileMovement.of((Vec3)forward).rot().f_82480_ * 57.2957763671875;
        double speed = Mth.m_14008_((double)(dist / 30.0), (double)1.5, (double)3.0);
        for (int i = 0; i < 8; ++i) {
            Vec3 dir = ori.rotateDegrees(45.0 * (double)i - angle);
            ItemDanmakuEntity e = holder.prepareDanmaku(40, dir.m_82490_(speed), YHDanmaku.Bullet.BALL, DyeColor.YELLOW);
            holder.shoot(e);
        }
    }

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        ItemDanmakuEntity e;
        Item item;
        if (danmaku instanceof ItemDanmakuEntity && (item = (e = (ItemDanmakuEntity)danmaku).m_7846_().m_41720_()) instanceof DanmakuItem) {
            DanmakuItem i = (DanmakuItem)item;
            if (i.color == DyeColor.BLUE || i.color == DyeColor.YELLOW) {
                return YHDamageTypes.abyssal(danmaku);
            }
        }
        return super.getDanmakuDamageSource(danmaku);
    }

    @Override
    public void hurt(CardHolder holder, DamageSource source, float amount) {
        Vec3 target;
        float mhp;
        float hp;
        super.hurt(holder, source, amount);
        if (this.tick < 10) {
            return;
        }
        if (source.m_7639_() != null) {
            this.border = true;
        }
        if ((hp = holder.self().m_21223_()) < (mhp = holder.self().m_21233_()) / 2.0f) {
            this.setAbyss(holder);
        }
        if ((target = holder.target()) == null) {
            return;
        }
        if (this.isAbyss(holder)) {
            double dist = holder.center().m_82554_(target);
            Vec3 dir = target.m_82546_(holder.center()).m_82541_();
            int n = 6;
            int m = 5;
            for (int i = 0; i < 3; ++i) {
                Vec3 ori = DanmakuHelper.getOrientation(dir).rotateDegrees(120.0 * ((double)i + 0.5), 0.0);
                Vec3 sec = DanmakuHelper.getOrientation(ori).rotateDegrees(90.0, -45.0);
                this.sequence(holder, dist, ori, sec, 6.0, 0.0, 2, n, m, 360.0 / (double)n / (double)m, YHDanmaku.Bullet.BUBBLE);
            }
        } else {
            double dist = holder.center().m_82554_(target);
            Vec3 dir = target.m_82546_(holder.center()).m_82541_();
            Vec3 ori = DanmakuHelper.getOrientation(dir).rotateDegrees(holder.random().m_188500_() * 120.0 + 30.0, 0.0);
            Vec3 sec = DanmakuHelper.getOrientation(ori).rotateDegrees(90.0, holder.random().m_188500_() * 60.0 - 30.0);
            this.sequence(holder, dist, ori, sec, 6.0, 0.0, 2, 8, 5, 9.0, YHDanmaku.Bullet.BUBBLE);
        }
    }

    private void sequence(CardHolder holder, double dist, Vec3 dir, Vec3 ori, double base, double bv, int delay, int n, int step, double angle, YHDanmaku.Bullet bullet) {
        Vec3 le = holder.target();
        if (le == null) {
            return;
        }
        RandomSource r = holder.random();
        Vec3 normal = dir.m_82537_(ori);
        int s = r.m_188500_() < 0.5 ? -1 : 1;
        for (int i = 0; i <= step; ++i) {
            StateChange ans = new StateChange();
            double perc = Mth.m_14008_((double)((dist - 16.0) / 24.0), (double)0.0, (double)1.0);
            double b = base + bv * (double)i;
            ans.r0 = (int)Mth.m_14139_((double)perc, (double)(b * 4.0), (double)(b * 10.0));
            ans.r1 = (int)Mth.m_14139_((double)perc, (double)(b * 3.0), (double)(b * 8.0));
            ans.t0 = (int)Mth.m_14139_((double)perc, (double)20.0, (double)10.0);
            ans.t1 = (int)Mth.m_14139_((double)perc, (double)20.0, (double)10.0);
            ans.termSpeed = (int)Mth.m_14139_((double)perc, (double)1.0, (double)3.0);
            ans.n = n;
            ans.bullet = bullet;
            ans.pos = holder.center();
            ans.init = DanmakuHelper.getOrientation(ori, normal).rotateDegrees((double)(s * (i - 2)) * angle);
            ans.normal = normal;
            ans.tick = -i * delay;
            if (this.isAbyss(holder)) {
                ans.color = DyeColor.BLUE;
            }
            this.addTicker(ans);
        }
    }

    private static boolean teleport(LivingEntity mob, Vec3 target) {
        Vec3 old = mob.m_20182_();
        mob.m_6021_(target.m_7096_(), target.m_7098_(), target.m_7094_());
        if (!mob.m_9236_().m_45786_((Entity)mob)) {
            mob.m_6021_(old.m_7096_(), old.m_7098_(), old.m_7094_());
            return false;
        }
        mob.m_9236_().m_7605_((Entity)mob, (byte)46);
        mob.m_9236_().m_214171_(GameEvent.f_238175_, mob.m_20182_(), GameEvent.Context.m_223717_((Entity)mob));
        if (!mob.m_20067_()) {
            mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
            mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return true;
    }

    @SerialClass
    public static class StateChange
    extends Ticker<ReimuSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 init;
        @SerialClass.SerialField
        private Vec3 normal;
        @SerialClass.SerialField
        private Vec3 target1;
        @SerialClass.SerialField
        private int r0 = 8;
        @SerialClass.SerialField
        private int r1 = 6;
        @SerialClass.SerialField
        private int n = 20;
        @SerialClass.SerialField
        private int t0 = 20;
        @SerialClass.SerialField
        private int t1 = 20;
        @SerialClass.SerialField
        private int t2 = 40;
        @SerialClass.SerialField
        private int dt = 20;
        @SerialClass.SerialField
        private double termSpeed = 1.0;
        @SerialClass.SerialField
        private YHDanmaku.Bullet bullet = YHDanmaku.Bullet.CIRCLE;
        @SerialClass.SerialField
        private DyeColor color = DyeColor.RED;

        @Override
        public boolean tick(CardHolder holder, ReimuSpell card) {
            this.step(holder);
            super.tick(holder, card);
            return this.tick > 0 || holder.target() == null;
        }

        private void step(CardHolder holder) {
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            RandomSource r = holder.random();
            if (this.init == null) {
                this.pos = holder.center();
                Vec3 dir = le.m_82546_(holder.center()).m_82541_();
                this.init = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, 60.0 * r.m_188500_() - 30.0);
                this.normal = dir.m_82537_(this.init);
            }
            if (this.tick < 0) {
                return;
            }
            if (this.tick == 0) {
                DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                double acc = (double)this.r0 * 2.0 / (double)this.t0 / (double)this.t0;
                for (int i = 0; i < this.n; ++i) {
                    Vec3 front = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 vec = front.m_82490_(acc * (double)this.t0);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t0, vec, this.bullet, DyeColor.LIGHT_GRAY);
                    e.mover = new RectMover(this.pos, vec, front.m_82490_(-acc));
                    e.afterExpiry = new HomingTrail().setup(this.t1, acc * (double)this.t1, 0.0, this.bullet, DyeColor.PURPLE).next(new HomingTrail().setup(this.t2 + r.m_188503_(this.dt), this.termSpeed, this.termSpeed, this.bullet, this.color));
                    holder.shoot(e);
                }
            }
        }
    }

    @SerialClass
    public static class Intercept
    extends Ticker<ReimuSpell> {
        @SerialClass.SerialField
        private Vec3 vec = Vec3.f_82478_;
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);
        @SerialClass.SerialField
        private double dist = 32.0;
        @SerialClass.SerialField
        private double w = 18.0;
        @SerialClass.SerialField
        private double speed = 2.0;
        @SerialClass.SerialField
        private double duration = 80.0;

        @Override
        public boolean tick(CardHolder holder, ReimuSpell card) {
            Vec3 target = holder.target();
            if (target != null) {
                this.vec = this.vec.m_82490_(0.95).m_82549_(target.m_82490_(0.05));
            }
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(this.dir);
            for (int i = 0; i < 8; ++i) {
                Vec3 off = ori.rotateDegrees(45.0 * (double)i);
                Vec3 pos = this.vec.m_82549_(this.dir.m_82549_(off.m_82490_(this.dist)));
                DanmakuHelper.Orientation nor = DanmakuHelper.getOrientation(off).asNormal();
                for (int j = 0; j < 8; ++j) {
                    Vec3 vel = nor.rotateDegrees(45.0 * (double)j + (double)this.tick * this.w).m_82490_(this.speed).m_82549_(off.m_82490_(-1.0));
                    int life = (int)Math.min(this.duration - (double)this.tick, 40.0) + holder.random().m_188503_(10);
                    ItemDanmakuEntity e = holder.prepareDanmaku(life, vel, YHDanmaku.Bullet.BUBBLE, DyeColor.YELLOW);
                    e.m_146884_(pos);
                    holder.shoot(e);
                }
            }
            super.tick(holder, card);
            return (double)this.tick > this.duration;
        }
    }

    @SerialClass
    public static class HomingTrail
    extends TrailAction {
        @SerialClass.SerialField
        private int life;
        @SerialClass.SerialField
        private double v0;
        @SerialClass.SerialField
        private double v1;
        @SerialClass.SerialField
        private YHDanmaku.Bullet bullet;
        @SerialClass.SerialField
        private DyeColor color;
        @SerialClass.SerialField
        private TrailAction next;

        public HomingTrail setup(int life, double v0, double v1, YHDanmaku.Bullet bullet, DyeColor color) {
            this.life = life;
            this.v0 = v0;
            this.v1 = v1;
            this.bullet = bullet;
            this.color = color;
            return this;
        }

        public HomingTrail next(TrailAction next) {
            this.next = next;
            return this;
        }

        @Override
        public void execute(CardHolder holder, Vec3 pos, Vec3 dir) {
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            Vec3 f2 = le.m_82546_(pos).m_82541_();
            Vec3 vec = f2.m_82490_(this.v0);
            Vec3 acc = f2.m_82490_((this.v1 - this.v0) / (double)this.life);
            ItemDanmakuEntity e = holder.prepareDanmaku(this.life, vec, this.bullet, this.color);
            e.m_146884_(pos);
            e.mover = new RectMover(pos, vec, acc);
            if (this.next != null) {
                e.afterExpiry = this.next;
            }
            holder.shoot(e);
        }
    }
}

