/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.custom.annotation;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.ArgField;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.ArgRange;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.IArgEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public record ArgGroup(Class<?> cls, List<ArgField> list) implements IArgEntry
{
    private static final Map<Class<?>, ArgGroup> CACHE = new LinkedHashMap();

    public static synchronized ArgGroup of(Class<?> cls) {
        if (!cls.isRecord()) {
            throw new IllegalArgumentException("Class " + cls + " is not a record");
        }
        ArgGroup old = CACHE.get(cls);
        if (old != null) {
            return old;
        }
        ArrayList<ArgField> entries = new ArrayList<ArgField>();
        for (RecordComponent e : cls.getRecordComponents()) {
            ArgRange arg = e.getAnnotation(ArgRange.class);
            if (arg == null) {
                entries.add(new ArgField(e, ArgGroup.of(e.getType())));
                continue;
            }
            entries.add(new ArgField(e, IArgEntry.of(e.getType(), arg)));
        }
        old = new ArgGroup(cls, entries);
        CACHE.put(cls, old);
        return old;
    }

    @Override
    public boolean verify(Object o) throws Exception {
        if (!this.cls.isInstance(o)) {
            return false;
        }
        for (ArgField e : this.list) {
            if (e.verifyField(o)) continue;
            return false;
        }
        return true;
    }

    public boolean verifySafe(Object data) {
        try {
            return this.verify(data);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public <T> T make(List<Object> args) throws Exception {
        ArrayList clss = new ArrayList();
        for (ArgField e : this.list) {
            clss.add(e.field().getType());
        }
        Constructor<?> factory = this.cls.getConstructor((Class[])clss.toArray(Class[]::new));
        return (T)Wrappers.cast(factory.newInstance(args.toArray()));
    }
}

