/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.tank;

import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2library.base.tile.BaseTank;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.overlay.InfoTile;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;

@SerialClass
public class CopperTankBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
InfoTile,
BaseContainerListener,
HeatableBlockEntity {
    @SerialClass.SerialField
    private final BaseTank water = new BaseTank(1, 8000).setPredicate(e -> e.getFluid().m_6212_((Fluid)Fluids.f_76193_)).add((BaseContainerListener)this);
    @SerialClass.SerialField
    private int heatedWater = 0;

    public CopperTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            if (this.f_58857_.m_46467_() % 5L != 0L) {
                return;
            }
            FluidState fluid = this.f_58857_.m_6425_(this.m_58899_().m_7494_());
            if (fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76170_() && this.getRoot().water.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                this.notifyTile();
            }
        } else {
            int next = !this.isHeated(this.f_58857_, this.m_58899_()) ? Math.max(0, this.heatedWater - 1) : this.heatedWater + 2;
            int ans = Math.min(this.water.getFluidInTank(0).getAmount(), next);
            if (ans != this.heatedWater) {
                this.heatedWater = ans;
                this.notifyTile();
            }
        }
    }

    public int consumeHeat(int consume) {
        CopperTankBlockEntity root = this.getRoot();
        int ans = Math.min(root.heatedWater, consume);
        root.heatedWater -= ans;
        return ans;
    }

    @Override
    public TileTooltip getImage(boolean shift, BlockHitResult hit) {
        return new TileTooltip(List.of(), List.of(this.getRoot().water.getFluidInTank(0)), 1, 1);
    }

    @Override
    public List<Component> lines(boolean shift, BlockHitResult hit) {
        CopperTankBlockEntity root = this.getRoot();
        int heat = root.heatedWater;
        int water = root.water.getFluidInTank(0).getAmount();
        if (water == 0) {
            return List.of();
        }
        int perc = Mth.m_14045_((int)(heat * 100 / water), (int)0, (int)100);
        return List.of(Component.m_237113_((String)(perc + "%")));
    }

    private CopperTankBlockEntity getRoot() {
        if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            Level level = this.m_58904_();
            if (level == null) {
                return this;
            }
            BlockEntity blockEntity = level.m_7702_(this.m_58899_().m_7495_());
            if (blockEntity instanceof CopperTankBlockEntity) {
                CopperTankBlockEntity be = (CopperTankBlockEntity)blockEntity;
                return be;
            }
        }
        return this;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            BaseTank ans = this.getRoot().water;
            return LazyOptional.of(() -> ans).cast();
        }
        return super.getCapability(cap, side);
    }

    public void notifyTile() {
        this.sync();
        this.m_6596_();
    }

    public int getHeat() {
        return this.getRoot().heatedWater;
    }
}

