/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.item;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodModelHelper;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodTableItemHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.item.BaseTableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.FoodTableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.FoodTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.item.IngredientTableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.VariantTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.model.FixedModelHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.model.ModelHolderManager;
import dev.xkmc.youkaishomecoming.content.pot.table.model.VariantModelHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.model.VariantModelPart;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class TableItemManager
extends BaseTableItem {
    public static final ModelHolderManager MANAGER = ModelHolderManager.createModelBuilderManager(YoukaisHomecoming.REGISTRATE);
    public static final TableItemManager TABLE = new TableItemManager();
    public static final IngredientTableItem RICE = TABLE.with(TableItemManager.fixed("rice").putDefault("rice"), () -> ((RegistryObject)ModItems.COOKED_RICE).get());
    public static final IngredientTableItem SUSHI = RICE.addNext(TableItemManager.variant("sushi").putDefault("rice"));
    public static final IngredientTableItem GUNKAN = SUSHI.with((FixedModelHolder)TableItemManager.variant("gunkan"), (ItemLike)Items.f_42576_);
    public static final IngredientTableItem RICE_2 = RICE.with(TableItemManager.fixed("rice_2").putDefault("rice"), () -> ((RegistryObject)ModItems.COOKED_RICE).get());
    public static final IngredientTableItem CAL = RICE_2.with((FixedModelHolder)TableItemManager.variant("open_california"), (ItemLike)Items.f_42576_);
    public static final IngredientTableItem KELP = TABLE.with(TableItemManager.fixed("kelp").putDefault("kelp"), (ItemLike)Items.f_42576_);
    public static final IngredientTableItem HOSOMAKI = KELP.with(TableItemManager.variant("open_hosomaki").putDefault("kelp", "rice"), () -> ((RegistryObject)ModItems.COOKED_RICE).get());
    public static final IngredientTableItem FUTOMAKI = HOSOMAKI.with(TableItemManager.variant("open_futomaki").putDefault("kelp", "rice"), () -> ((RegistryObject)ModItems.COOKED_RICE).get());
    public static final VariantTableItemBase BASE_SUSHI = SUSHI.asBase(YoukaisHomecoming.loc("sushi"));
    public static final VariantTableItemBase BASE_GUNKAN = GUNKAN.asBase(YoukaisHomecoming.loc("gunkan"));
    public static final VariantTableItemBase BASE_HOSOMAKI = HOSOMAKI.asBase(YoukaisHomecoming.loc("hosomaki"));
    public static final VariantTableItemBase BASE_FUTOMAKI = FUTOMAKI.asBase(YoukaisHomecoming.loc("futomaki"));
    public static final VariantTableItemBase BASE_CAL = CAL.asBase(YoukaisHomecoming.loc("california"));
    public static final VariantModelPart SUSHI_TOP = BASE_SUSHI.addPart("top", 1);
    public static final VariantModelPart GUNKAN_TOP = BASE_GUNKAN.addPart("top", 1);
    public static final VariantModelPart HOSOMAKI_SAUCE = BASE_HOSOMAKI.addPart("sauce", 1);
    public static final VariantModelPart HOSOMAKI_INGREDIENT = BASE_HOSOMAKI.addPart("ingredient", 1);
    public static final VariantModelPart FUTOMAKI_SAUCE = BASE_FUTOMAKI.addPart("sauce", 1);
    public static final VariantModelPart FUTOMAKI_INGREDIENT = BASE_FUTOMAKI.addPart("ingredient", 3);
    public static final VariantModelPart CAL_INGREDIENT = BASE_CAL.addPart("ingredient", 3);
    public static final FoodTableItemBase COMPLETE_HOSOMAKI = BASE_HOSOMAKI.addNextStep(null);
    public static final FoodTableItemBase COMPLETE_FUTOMAKI = BASE_FUTOMAKI.addNextStep(null);
    public static final FoodTableItemBase COMPLETE_CAL = BASE_CAL.addNextStep(null);

    private static FixedModelHolder fixed(String id) {
        return new FixedModelHolder(MANAGER, YoukaisHomecoming.loc("fixed/" + id));
    }

    private static VariantModelHolder variant(String id) {
        return new VariantModelHolder(MANAGER, YoukaisHomecoming.loc(id));
    }

    private static void addBulk(String id, String path, ItemLike item, VariantModelPart ... parts) {
        for (VariantModelPart part : parts) {
            part.addMapping(id, item).tex(YoukaisHomecoming.loc("block/table/" + path));
        }
    }

    private static void addBulk(String id, String path, TagKey<Item> item, VariantModelPart ... parts) {
        for (VariantModelPart part : parts) {
            part.addMapping(id, item).tex(YoukaisHomecoming.loc("block/table/" + path));
        }
    }

    @Override
    public Optional<TableItem> find(Level level, ItemStack stack) {
        Optional<TableItem> ans = super.find(level, stack);
        if (ans.isPresent()) {
            return ans;
        }
        FoodTableItemHolder preset = FoodModelHelper.find(stack);
        if (preset != null) {
            return Optional.of(new FoodTableItem(stack));
        }
        return Optional.empty();
    }

    public Either<TableItem, Pair<TableItem, List<ItemStack>>> find(Level level, List<ItemStack> list) {
        TableItem ans = TABLE;
        ArrayList<ItemStack> success = new ArrayList<ItemStack>();
        for (ItemStack e : list) {
            Optional<TableItem> opt = ans.find(level, e);
            if (opt.isEmpty()) {
                return Either.right((Object)Pair.of((Object)ans, success));
            }
            success.add(e);
            ans = opt.get();
        }
        return Either.left((Object)ans);
    }

    public static void init() {
    }

    static {
        SUSHI_TOP.addMapping("salmon", (TagKey<Item>)ForgeTags.RAW_FISHES_SALMON);
        GUNKAN_TOP.addMapping("salmon_roe", (ItemLike)YHFood.ROE.item);
        TableItemManager.addBulk("soy_sauce", "sauce/soy_sauce", YHItems.SOY_SAUCE_BOTTLE.item, new VariantModelPart[]{HOSOMAKI_SAUCE, FUTOMAKI_SAUCE});
        VariantModelPart[] rolls = new VariantModelPart[]{HOSOMAKI_INGREDIENT, FUTOMAKI_INGREDIENT, CAL_INGREDIENT};
        TableItemManager.addBulk("salmon", "ingredient/salmon", (TagKey<Item>)ForgeTags.RAW_FISHES_SALMON, rolls);
        TableItemManager.addBulk("carrot", "ingredient/carrot", (ItemLike)Items.f_42619_, rolls);
        TableItemManager.addBulk("cabbage", "ingredient/cabbage", (TagKey<Item>)ForgeTags.SALAD_INGREDIENTS_CABBAGE, rolls);
    }
}

