/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.item;

import dev.xkmc.youkaishomecoming.content.pot.table.item.BaseTableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItem;
import dev.xkmc.youkaishomecoming.content.pot.table.item.VariantTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.model.FixedModelHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.model.VariantModelHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IngredientTableItem
extends BaseTableItem {
    private final TableItem prev;
    private final Lazy<Ingredient> ingredient;
    private final FixedModelHolder model;
    private final int step;
    @Nullable
    private VariantTableItemBase variant;

    public IngredientTableItem(BaseTableItem prev, Supplier<Ingredient> ingredient, FixedModelHolder model) {
        this.prev = prev;
        this.ingredient = Lazy.of(ingredient);
        this.model = model;
        this.step = prev.step() + 1;
    }

    public Ingredient ingredient() {
        return (Ingredient)this.ingredient.get();
    }

    @Override
    public int step() {
        return this.step;
    }

    public synchronized VariantTableItemBase asBase(ResourceLocation id) {
        if (this.variant != null) {
            throw new IllegalStateException("Already has a base");
        }
        FixedModelHolder fixedModelHolder = this.model;
        if (!(fixedModelHolder instanceof VariantModelHolder)) {
            throw new IllegalStateException("Variant item requires a variant model");
        }
        VariantModelHolder holder = (VariantModelHolder)fixedModelHolder;
        this.variant = VariantTableItemBase.create(this, id, holder);
        return this.variant;
    }

    @Override
    public void collectIngredients(List<Ingredient> list) {
        this.prev.collectIngredients(list);
        list.add((Ingredient)this.ingredient.get());
    }

    @Override
    public Optional<TableItem> find(Level level, ItemStack stack) {
        Optional<TableItem> ans = super.find(level, stack);
        if (ans.isPresent()) {
            return ans;
        }
        if (this.variant == null) {
            return Optional.empty();
        }
        return this.variant.find(level, stack);
    }

    @Override
    public List<ResourceLocation> getModels() {
        return List.of(this.model.modelLoc());
    }
}

