/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.item;

import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodModelHelper;
import dev.xkmc.youkaishomecoming.content.pot.table.food.FoodTableItemHolder;
import dev.xkmc.youkaishomecoming.content.pot.table.item.TableItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodTableItem
implements TableItem {
    private final List<ItemStack> contents;
    private final ItemStack current;
    @Nullable
    private final FoodTableItemHolder holder;

    public FoodTableItem(ItemStack current) {
        this.contents = List.of();
        this.current = current;
        this.holder = FoodModelHelper.find(current);
    }

    private FoodTableItem(ItemStack current, FoodTableItemHolder holder, List<ItemStack> contents) {
        this.contents = contents;
        this.current = current;
        this.holder = holder;
    }

    @Override
    public Optional<TableItem> find(Level level, ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public Optional<ItemStack> doTransform() {
        return this.contents.isEmpty() ? Optional.of(this.current) : Optional.empty();
    }

    @Override
    public int step() {
        return this.contents.size() + 1;
    }

    @Override
    public Optional<ItemStack> complete(Level level) {
        if (this.contents.isEmpty()) {
            return Optional.of(this.current.m_41777_());
        }
        return Optional.empty();
    }

    @Override
    public List<ResourceLocation> getModels() {
        if (this.holder == null) {
            return List.of();
        }
        if (this.contents.isEmpty() || this.holder.base().additional == null) {
            return List.of(this.holder.model().modelLoc());
        }
        ArrayList<ResourceLocation> ans = new ArrayList<ResourceLocation>();
        ans.add(this.holder.model().modelLoc());
        this.holder.base().additional.buildContents(ans, this.contents);
        return ans;
    }
}

