/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.steamer;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.item.food.FoodSaucerItem;
import dev.xkmc.youkaishomecoming.content.pot.steamer.RackItemData;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerBlockEntity;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class RackData {
    public static final double UPWARD_EFF = 0.01;
    public static final double DOWNWARD_EFF = 0.05;
    @SerialClass.SerialField
    public final RackItemData[] list = new RackItemData[4];
    @SerialClass.SerialField
    public double upwardHeat = 0.0;
    @SerialClass.SerialField
    public double downwardHeat = 0.0;

    public void tick(SteamerBlockEntity be, Level level) {
        int count = 0;
        for (RackItemData e : this.list) {
            double heat = this.upwardHeat * 0.01 + this.downwardHeat * 0.05;
            if (e == null || !e.tick(be, level, heat)) continue;
            ++count;
        }
        this.upwardHeat -= (double)count * 0.01;
        this.downwardHeat -= (double)count * 0.05;
    }

    public void popItems(Level level, BlockPos pos, int height) {
        if (level.m_5776_()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            RackItemData item = this.list[i];
            if (item == null || item.stack.m_41619_()) continue;
            RackData.popResource(level, pos.m_7494_(), item.stack, (double)height * 0.25);
            this.list[i] = null;
        }
    }

    public boolean tryAddItem(SteamerBlockEntity be, Level level, ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            if (!this.tryAddItemAt(be, level, stack, i)) continue;
            return true;
        }
        return false;
    }

    public boolean tryAddItemAt(SteamerBlockEntity be, Level level, ItemStack stack, Vec3 hit) {
        return this.tryAddItemAt(be, level, stack, RackData.getIndex(hit));
    }

    protected boolean tryAddItemAt(SteamerBlockEntity be, Level level, ItemStack stack, int index) {
        if (stack.m_41720_() instanceof FoodSaucerItem) {
            if (index != 0) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.list[index] == null || this.list[index].stack.m_41619_()) continue;
                return false;
            }
        }
        if (index < 0 || index >= 4) {
            return false;
        }
        RackItemData item = this.list[index];
        if (item != null && !item.stack.m_41619_()) {
            return false;
        }
        if (item == null) {
            this.list[index] = item = new RackItemData();
        }
        if (!item.stack.m_41619_()) {
            return false;
        }
        if (!level.m_5776_()) {
            item.setStack(be, stack.m_41620_(1));
        }
        return true;
    }

    public boolean tryTakeItem(SteamerBlockEntity be, Level level, Player player, InteractionHand hand) {
        for (int i = 3; i >= 0; --i) {
            if (!this.tryTakeItemAt(be, level, i, player, hand)) continue;
            return true;
        }
        return false;
    }

    public boolean tryTakeItemAt(SteamerBlockEntity be, Level level, Vec3 hit, Player player, InteractionHand hand) {
        return this.tryTakeItemAt(be, level, RackData.getIndex(hit), player, hand);
    }

    protected boolean tryTakeItemAt(SteamerBlockEntity be, Level level, int index, Player player, InteractionHand hand) {
        if (index < 0 || index >= 4) {
            return false;
        }
        RackItemData item = this.list[index];
        if (item == null || item.stack.m_41619_()) {
            return false;
        }
        if (!level.m_5776_()) {
            player.m_150109_().m_150079_(item.stack);
            item.setStack(be, ItemStack.f_41583_);
        }
        return true;
    }

    public static boolean isValid(Level level, ItemStack stack) {
        if (stack.getFoodProperties(null) != null) {
            return true;
        }
        SimpleContainer cont = new SimpleContainer(1);
        cont.m_6836_(0, stack);
        return level.m_7465_().m_44015_((RecipeType)YHBlocks.STEAM_RT.get(), (Container)cont, level).isPresent();
    }

    private static int getIndex(Vec3 hit) {
        boolean sz;
        boolean sx = Mth.m_14109_((double)hit.f_82479_, (double)1.0) > 0.5;
        boolean bl = sz = Mth.m_14109_((double)hit.f_82481_, (double)1.0) > 0.5;
        return sx ? (sz ? 2 : 1) : (sz ? 3 : 0);
    }

    private static void popResource(Level level, BlockPos pos, ItemStack stack, double height) {
        double x = (double)pos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1);
        double h = (double)pos.m_123342_() + height;
        double z = (double)pos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1);
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46136_) && !level.restoringBlockSnapshots) {
            ItemEntity itementity = new ItemEntity(level, x, h, z, stack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
    }
}

