/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.rack;

import dev.xkmc.youkaishomecoming.content.pot.rack.DryingRackRecipe;
import dev.xkmc.youkaishomecoming.content.pot.rack.DryingRackWrapper;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class DryingRackBlockEntity
extends SyncedBlockEntity {
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> list = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final ItemStackHandler items = new ItemStackHandler(this.list);
    private final DryingRackWrapper handler = new DryingRackWrapper(this);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<Container, DryingRackRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)YHBlocks.RACK_RT.get()));

    public DryingRackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, DryingRackBlockEntity be) {
        if (!level.m_45527_(pos)) {
            return;
        }
        if (!level.m_46461_()) {
            return;
        }
        if (level.m_46758_(pos)) {
            return;
        }
        be.cookTick();
    }

    private void cookTick() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        for (int i = 0; i < this.items.getSlots(); ++i) {
            SimpleContainer container;
            ItemStack result;
            ItemStack itemstack = this.items.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            int n = i;
            this.cookingProgress[n] = this.cookingProgress[n] + 1;
            if (this.cookingProgress[i] < this.cookingTime[i] || !(result = this.quickCheck.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{itemstack})), this.f_58857_).map(arg_0 -> this.lambda$cookTick$0((Container)container, arg_0)).orElse(itemstack)).m_246617_(this.f_58857_.m_246046_())) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)result);
            this.items.setStackInSlot(i, ItemStack.f_41583_);
            this.inventoryChanged();
            this.f_58857_.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.list;
    }

    public void m_142466_(CompoundTag pTag) {
        int[] times;
        super.m_142466_(pTag);
        this.list.clear();
        ContainerHelper.m_18980_((CompoundTag)pTag, this.list);
        if (pTag.m_128425_("CookingTimes", 11)) {
            times = pTag.m_128465_("CookingTimes");
            System.arraycopy(times, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, times.length));
        }
        if (pTag.m_128425_("CookingTotalTimes", 11)) {
            times = pTag.m_128465_("CookingTotalTimes");
            System.arraycopy(times, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, times.length));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18976_((CompoundTag)pTag, this.list, (boolean)true);
        pTag.m_128385_("CookingTimes", this.cookingProgress);
        pTag.m_128385_("CookingTotalTimes", this.cookingTime);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.list, (boolean)true);
        return compoundtag;
    }

    public Optional<DryingRackRecipe> getCookableRecipe(ItemStack pStack) {
        assert (this.f_58857_ != null);
        return this.list.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{pStack}), this.f_58857_);
    }

    public boolean placeFood(ItemStack stack, int time) {
        assert (this.f_58857_ != null);
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack itemstack = this.items.getStackInSlot(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTime[i] = time;
            this.cookingProgress[i] = 0;
            this.items.setStackInSlot(i, stack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStackHandler getInventory() {
        return this.items;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction dire) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (dire == Direction.DOWN) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.handler).cast();
        }
        return super.getCapability(cap, dire);
    }

    private /* synthetic */ ItemStack lambda$cookTick$0(Container container, DryingRackRecipe r) {
        return r.m_5874_(container, this.f_58857_.m_9598_());
    }
}

