/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.kettle;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.l2library.serial.ingredients.PotionIngredient;
import dev.xkmc.youkaishomecoming.content.block.variants.LeftClickBlock;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotBlock;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleBlockEntity;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.util.Lazy;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;

public class KettleBlock
extends BasePotBlock
implements LeftClickBlock {
    protected static final VoxelShape SHAPE = KettleBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)KettleBlock.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));
    protected static final Lazy<Map<Ingredient, Integer>> MAP = Lazy.of(() -> Map.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}), 600, new PotionIngredient(Potions.f_43599_), 200));

    public KettleBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KettleBlockEntity) {
            KettleBlockEntity kettle = (KettleBlockEntity)blockEntity;
            for (Map.Entry entry : ((Map)MAP.get()).entrySet()) {
                if (!((Ingredient)entry.getKey()).test(stack)) continue;
                if (!level.m_5776_()) {
                    if (kettle.getWater() < 600) {
                        kettle.addWater((Integer)entry.getValue());
                        if (!player.m_150110_().f_35937_) {
                            ItemStack remain = stack.getCraftingRemainingItem();
                            stack.m_41774_(1);
                            player.m_150109_().m_150079_(remain);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.CONSUME;
            }
            if (!stack.m_41619_()) {
                ItemStack toInsert = player.m_6144_() ? stack.m_41777_() : stack.m_255036_(1);
                ItemStack itemStack = kettle.addItem(toInsert);
                if (itemStack.m_41613_() < toInsert.m_41613_()) {
                    if (!level.m_5776_()) {
                        stack.m_41774_(toInsert.m_41613_() - itemStack.m_41613_());
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (player.m_6144_() && !kettle.isGridEmpty()) {
                if (!level.m_5776_()) {
                    kettle.popAll();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Override
    public boolean leftClick(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KettleBlockEntity) {
            KettleBlockEntity be = (KettleBlockEntity)blockEntity;
            if (level.f_46443_) {
                return true;
            }
            ItemStack stack = this.m_5456_().m_7968_();
            CompoundTag tag = be.writeMeal(new CompoundTag());
            if (!tag.m_128456_()) {
                stack.m_41700_("BlockEntityTag", (Tag)tag);
            }
            if (be.m_8077_()) {
                stack.m_41714_(be.m_5446_());
            }
            level.m_7471_(pos, false);
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, stack);
            } else {
                KettleBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
            return true;
        }
        return false;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)YHLangData.KETTLE_INFO.get(new Object[0]));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((CookingPotSupport)state.m_61143_((Property)SUPPORT)).equals((Object)CookingPotSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)YHBlocks.KETTLE_BE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.f_46443_ ? KettleBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)YHBlocks.KETTLE_BE.get()), BasePotBlockEntity::animationTick) : KettleBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)YHBlocks.KETTLE_BE.get()), BasePotBlockEntity::cookingTick);
    }

    public static void buildModel(DataGenContext<Block, KettleBlock> ctx, RegistrateBlockstateProvider pvd) {
        BlockModelBuilder kettle = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/kettle")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/utensil/kettle")))).texture("kettle", pvd.modLoc("block/kettle"))).renderType("cutout");
        BlockModelBuilder handle = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/kettle_handle")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/utensil/kettle_handle")))).texture("kettle", pvd.modLoc("block/kettle"))).texture("handle", pvd.modLoc("block/cooking_pot_handle"))).texture("chain", pvd.modLoc("block/chain"))).renderType("cutout");
        BlockModelBuilder tray = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/kettle_tray")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/utensil/kettle_tray")))).texture("kettle", pvd.modLoc("block/kettle"))).texture("tray_side", pvd.modLoc("block/cooking_pot_tray_side"))).texture("tray_top", pvd.modLoc("block/cooking_pot_tray_top"))).renderType("cutout");
        pvd.horizontalBlock((Block)ctx.get(), state -> switch ((CookingPotSupport)state.m_61143_((Property)SUPPORT)) {
            default -> throw new IncompatibleClassChangeError();
            case CookingPotSupport.NONE -> kettle;
            case CookingPotSupport.HANDLE -> handle;
            case CookingPotSupport.TRAY -> tray;
        });
    }
}

