/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.food;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.item.food.IFleshFoodItem;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class YHFoodItem
extends Item {
    private final UseAnim anim;

    private static Component getTooltip(MobEffectInstance eff) {
        MutableComponent ans = Component.m_237115_((String)eff.m_19576_());
        MobEffect mobeffect = eff.m_19544_();
        if (eff.m_19564_() > 0) {
            ans = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.m_237115_((String)("potion.potency." + eff.m_19564_()))});
        }
        if (eff.m_19557_() > 20) {
            ans = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.m_267641_((MobEffectInstance)eff, (float)1.0f)});
        }
        return ans.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static void getFoodEffects(ItemStack stack, List<Component> list) {
        FoodProperties food = stack.getFoodProperties((LivingEntity)IFleshFoodItem.getPlayer());
        if (food == null) {
            return;
        }
        YHFoodItem.getFoodEffects(food, list);
    }

    public static void getFoodEffects(FoodProperties food, List<Component> list) {
        for (Pair eff : food.m_38749_()) {
            int chance = Math.round(((Float)eff.getSecond()).floatValue() * 100.0f);
            if (eff.getFirst() == null) continue;
            Component ans = YHFoodItem.getTooltip((MobEffectInstance)eff.getFirst());
            if (chance == 100) {
                list.add(ans);
                continue;
            }
            list.add((Component)YHLangData.CHANCE_EFFECT.get(ans, chance));
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity consumer) {
        ItemStack itemStack = this.getCraftingRemainingItem(stack);
        boolean youkai = consumer.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get());
        super.m_5922_(stack, worldIn, consumer);
        if (!youkai && consumer.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get())) {
            int dur = (Integer)YHModConfig.COMMON.youkaifyingConfusionTime.get();
            consumer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, dur, 0, false, false, true));
        }
        if (itemStack.m_41619_()) {
            return stack;
        }
        if (stack.m_41619_()) {
            return itemStack;
        }
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            if (!player.m_150110_().f_35937_ && !player.m_150109_().m_36054_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
        }
        return stack;
    }

    public YHFoodItem(Item.Properties props, UseAnim anim) {
        super(props);
        this.anim = anim;
    }

    public YHFoodItem(Item.Properties props) {
        this(props, UseAnim.EAT);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.anim;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            YHFoodItem.getFoodEffects(stack, list);
        }
    }
}

