/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.food;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.effect.YoukaifiedEffect;
import dev.xkmc.youkaishomecoming.content.effect.YoukaifyingEffect;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.TouhouHatItem;
import dev.xkmc.youkaishomecoming.content.item.food.FleshHelper;
import dev.xkmc.youkaishomecoming.events.ReimuEventHandlers;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public interface IFleshFoodItem
extends ItemLike {
    @Nullable
    public static Player getPlayer() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return FleshHelper.getPlayerOnClient();
        }
        return null;
    }

    @Nullable
    default public FoodProperties getFleshFoodProps(@Nullable FoodProperties old, @Nullable LivingEntity entity) {
        if (old == null) {
            return null;
        }
        int factor = 1;
        if (entity != null) {
            if (entity.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
                factor = 3;
            } else if (entity.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get())) {
                factor = 2;
            }
        }
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(old.m_38744_() * factor);
        builder.m_38758_(old.m_38745_());
        if (old.m_38747_()) {
            builder.m_38765_();
        }
        if (old.m_38748_()) {
            builder.m_38766_();
        }
        if (old.m_38746_()) {
            builder.m_38757_();
        }
        for (Pair ent : old.m_38749_()) {
            if (((MobEffectInstance)ent.getFirst()).m_19544_().m_19486_()) {
                if (factor <= 1) continue;
            }
            builder.effect(() -> ((Pair)ent).getFirst(), ((Float)ent.getSecond()).floatValue());
        }
        return builder.m_38767_();
    }

    default public void appendFleshText(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Player player = IFleshFoodItem.getPlayer();
        if (player == null) {
            return;
        }
        if (player.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
            list.add((Component)YHLangData.FLESH_TASTE_YOUKAI.get(new Object[0]));
        } else if (player.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get())) {
            list.add((Component)YHLangData.FLESH_TASTE_HALF_YOUKAI.get(new Object[0]));
        } else if (this.m_5456_().m_7968_().m_204117_(YHTagGen.APPARENT_FLESH_FOOD)) {
            list.add((Component)YHLangData.FLESH_TASTE_HUMAN.get(new Object[0]));
        }
        if (this.m_5456_() == YHFood.FLESH.item.get()) {
            MutableComponent obt;
            boolean obtain = TouhouHatItem.showTooltip();
            if (obtain) {
                MutableComponent fying = Component.m_237115_((String)((YoukaifyingEffect)((Object)YHEffects.YOUKAIFYING.get())).m_19481_());
                MutableComponent fied = Component.m_237115_((String)((YoukaifiedEffect)((Object)YHEffects.YOUKAIFIED.get())).m_19481_());
                obt = YHLangData.OBTAIN_FLESH.get(fying, fied);
            } else {
                obt = YHLangData.UNKNOWN.get(new Object[0]);
            }
            list.add((Component)YHLangData.OBTAIN.get(new Object[0]).m_7220_((Component)obt));
        }
    }

    default public Component getFleshName(ItemStack pStack) {
        Player player = IFleshFoodItem.getPlayer();
        MutableComponent name = player != null && player.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()) ? YHLangData.FLESH_NAME_YOUKAI.get(new Object[0]) : YHLangData.FLESH_NAME_HUMAN.get(new Object[0]);
        return Component.m_237110_((String)this.m_5456_().m_5671_(pStack), (Object[])new Object[]{name});
    }

    default public void consume(Player consumer) {
        if (consumer.m_9236_().m_5776_()) {
            return;
        }
        if (consumer.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
            MobEffectInstance eff = consumer.m_21124_((MobEffect)YHEffects.YOUKAIFIED.get());
            if (eff != null) {
                int dur = eff.m_19557_() + (Integer)YHModConfig.COMMON.youkaifiedProlongation.get();
                consumer.m_7292_(new MobEffectInstance((MobEffect)YHEffects.YOUKAIFIED.get(), dur, 0, true, false, true));
            }
        } else if (consumer.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get())) {
            MobEffectInstance eff = consumer.m_21124_((MobEffect)YHEffects.YOUKAIFYING.get());
            if (eff != null) {
                int dur = eff.m_19557_() + (Integer)YHModConfig.COMMON.youkaifyingTime.get();
                if (dur > (Integer)YHModConfig.COMMON.youkaifyingThreshold.get()) {
                    dur = (Integer)YHModConfig.COMMON.youkaifiedDuration.get();
                    consumer.m_21195_((MobEffect)YHEffects.YOUKAIFYING.get());
                    consumer.m_7292_(new MobEffectInstance((MobEffect)YHEffects.YOUKAIFIED.get(), dur, 0, true, false, true));
                } else {
                    consumer.m_7292_(new MobEffectInstance((MobEffect)YHEffects.YOUKAIFYING.get(), dur, 0, false, false, false));
                }
            }
        } else if (consumer.m_217043_().m_188500_() < (Double)YHModConfig.COMMON.youkaifyingChance.get()) {
            int dur = (Integer)YHModConfig.COMMON.youkaifyingTime.get();
            consumer.m_7292_(new MobEffectInstance((MobEffect)YHEffects.YOUKAIFYING.get(), dur, 0, false, false, false));
            dur = (Integer)YHModConfig.COMMON.youkaifyingConfusionTime.get();
            consumer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, dur, 0, false, false, true));
        }
        if (this.m_5456_().m_7968_().m_204117_(YHTagGen.APPARENT_FLESH_FOOD) && consumer instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)consumer;
            ReimuEventHandlers.triggerReimuResponse((LivingEntity)sp, 24, true);
        }
    }
}

