/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlipFluidWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    protected ItemStack container;

    public SlipFluidWrapper(ItemStack container) {
        this.container = container;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid.getFluid() instanceof YHFluid;
    }

    @NotNull
    public FluidStack getFluid() {
        CompoundTag root = this.container.m_41783_();
        if (root == null || !root.m_128425_("SakeFluid", 10)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)root.m_128469_("SakeFluid"));
    }

    protected void setFluid(@NotNull FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            if (this.container.m_41783_() == null) {
                return;
            }
            this.container.m_41784_().m_128473_("SakeFluid");
            if (this.container.m_41784_().m_128456_()) {
                this.container.m_41751_(null);
            }
        }
        this.container.m_41784_().m_128365_("SakeFluid", (Tag)fluidStack.writeToNBT(new CompoundTag()));
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.isEmpty() || stack.getFluid() instanceof YHFluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack current = this.getFluid();
        if (current.isEmpty() || current.isFluidEqual(resource)) {
            int toFill = Math.min(this.getTankCapacity(0) - current.getAmount(), resource.getAmount());
            if (action.execute()) {
                FluidStack copy = resource.copy();
                copy.setAmount(toFill + current.getAmount());
                this.setFluid(copy);
            }
            return toFill;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack current = this.getFluid();
        if (current.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (current.isFluidEqual(resource)) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current = this.getFluid();
        if (current.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(current.getAmount(), maxDrain);
        FluidStack ans = current.copy();
        ans.setAmount(toDrain);
        if (action.execute()) {
            FluidStack copy = current.copy();
            copy.setAmount(current.getAmount() - toDrain);
            this.setFluid(copy);
        }
        return ans;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
    }
}

