/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import dev.xkmc.youkaishomecoming.content.item.fluid.SakeBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SakeFluidWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    protected ItemStack container;

    public SakeFluidWrapper(ItemStack container) {
        this.container = container;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFillFluidType(FluidStack fluid) {
        Fluid fluid2 = fluid.getFluid();
        if (!(fluid2 instanceof YHFluid)) return false;
        YHFluid sake = (YHFluid)fluid2;
        if (sake.type.getContainer() != this.container.m_41720_()) return false;
        return true;
    }

    @NotNull
    public FluidStack getFluid() {
        Item item = this.container.m_41720_();
        if (item instanceof SakeBottleItem) {
            SakeBottleItem sake = (SakeBottleItem)item;
            return new FluidStack((Fluid)sake.getFluid(), sake.getFluid().type.amount());
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@NotNull FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.container = this.container.getCraftingRemainingItem();
        } else {
            Fluid fluid = fluidStack.getFluid();
            if (fluid instanceof YHFluid) {
                YHFluid sake = (YHFluid)fluid;
                this.container = sake.type.asStack(fluidStack.getAmount() / sake.type.amount());
            }
        }
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (stack.isEmpty()) return true;
        Fluid fluid = stack.getFluid();
        if (!(fluid instanceof YHFluid)) return false;
        YHFluid sake = (YHFluid)fluid;
        if (sake.type.getContainer() != this.container.m_41720_()) return false;
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int cap = this.getTankCapacity(0);
        if (this.container.m_41613_() != 1 || resource.getAmount() < cap || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return cap;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int cap = this.getTankCapacity(0);
        if (this.container.m_41613_() != 1 || resource.getAmount() < cap) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this.getFluid();
        if (!stack.isEmpty() && stack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return stack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int cap = this.getTankCapacity(0);
        if (this.container.m_41613_() != 1 || maxDrain < cap) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
    }
}

