/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.danmaku;

import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.item.danmaku.ISpellItem;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.ISpellFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.screen.ClientCustomSpellHandler;
import dev.xkmc.youkaishomecoming.content.spell.item.SpellContainer;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class CustomSpellItem
extends Item
implements IGlowingTarget,
ISpellItem {
    private final ISpellFormData<?> def;
    private final boolean requireTarget;

    private ISpellFormData<?> getData(ItemStack stack) {
        Object obj;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("SpellData") && (obj = TagCodec.valueFromTag((Tag)tag.m_128469_("SpellData"), Record.class)) instanceof ISpellFormData) {
            ISpellFormData dat = (ISpellFormData)obj;
            return dat;
        }
        return this.def;
    }

    public CustomSpellItem(Item.Properties properties, boolean requireTarget, ISpellFormData<?> def) {
        super(properties);
        this.requireTarget = requireTarget;
        this.def = def;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ISpellFormData<?> data = this.getData(stack);
        if (player.m_6144_()) {
            if (level.m_5776_()) {
                ClientCustomSpellHandler.open(data);
            }
        } else {
            boolean consume;
            boolean bl = consume = !player.m_150110_().f_35937_ && !(player instanceof FakePlayer);
            if (!this.castSpellImpl(data, player, consume, true)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public boolean castSpell(ItemStack stack, Player player, boolean consume, boolean cooldown) {
        return this.castSpellImpl(this.getData(stack), player, consume, cooldown);
    }

    private boolean castSpellImpl(ISpellFormData<?> data, Player player, boolean consume, boolean cooldown) {
        if (GrazeHelper.forbidDanmaku(player)) {
            return false;
        }
        LivingEntity target = RayTraceUtil.serverGetTarget((Player)player);
        if (target != null) {
            GrazeHelper.addSession(player, target);
        }
        if (this.requireTarget && target == null && (target = GrazeHelper.getTarget(player)) == null) {
            return false;
        }
        if (consume) {
            int toCost;
            Item ammo = data.getAmmoCost();
            if (!CustomSpellItem.consumeAmmo(ammo, toCost = data.cost(), player, false)) {
                return false;
            }
            if (player instanceof ServerPlayer) {
                CustomSpellItem.consumeAmmo(ammo, toCost, player, true);
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SpellContainer.castSpell(sp, data::createInstance, target);
            if (cooldown) {
                player.m_36335_().m_41524_((Item)this, data.getDuration());
            }
        }
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        ISpellFormData<?> data = this.getData(stack);
        list.add((Component)YHLangData.SPELL_COST.get(data.cost(), data.getAmmoCost()));
        if (this.requireTarget) {
            list.add((Component)YHLangData.SPELL_TARGET.get(new Object[0]));
        }
    }

    private static boolean consumeAmmo(Item ammo, int toCost, Player player, boolean execute) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_() && toCost > 0; ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!item.m_150930_(ammo)) continue;
            int consume = Math.min(toCost, item.m_41613_());
            if (execute) {
                item.m_41774_(consume);
            }
            toCost -= consume;
        }
        return toCost == 0;
    }

    public void m_6883_(ItemStack stack, Level level, Entity user, int slot, boolean sel) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (level.f_46443_ && sel) {
                RayTraceUtil.clientUpdateTarget((Player)player, (double)64.0);
            }
        }
    }

    public int getDistance(ItemStack stack) {
        return 64;
    }
}

