/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuParticleHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.YHBaseLaserEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.LaserItem;
import dev.xkmc.youkaishomecoming.content.spell.mover.CompositeMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.DanmakuMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverInfo;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverOwner;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.ZeroMover;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ItemLaserEntity
extends YHBaseLaserEntity
implements ItemSupplier,
MoverOwner {
    @SerialClass.SerialField
    public DanmakuMover mover;
    @SerialClass.SerialField
    public ItemStack stack = ItemStack.f_41583_;
    private Float sizeCache = null;
    private boolean isErased = false;
    private int lastGraze = 0;

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends YHBaseLaserEntity>)pEntityType, pLevel);
    }

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public void setDelayedMover(float v0, float v1, int prepare, int setup) {
        Vec3 dir = this.m_20156_();
        Vec3 pos = this.f_19825_;
        CompositeMover m = new CompositeMover();
        m.add(prepare, new ZeroMover(dir, dir, prepare));
        m.add(setup, new RectMover(pos, dir.m_82490_((double)v0), Vec3.f_82478_));
        m.add(this.life, new RectMover(pos.m_82549_(dir.m_82490_((double)(v0 * (float)setup))), dir.m_82490_((double)v1), Vec3.f_82478_));
        this.mover = m;
    }

    @Override
    public TraceableEntity asTraceable() {
        return this;
    }

    @Override
    protected void danmakuMove() {
        ProjectileMovement movement = this.updateVelocity(this.m_20184_(), this.m_20182_());
        this.m_20256_(movement.vec());
        this.updateRotation(movement.rot());
        double d2 = this.m_20185_() + movement.vec().f_82479_;
        double d0 = this.m_20186_() + movement.vec().f_82480_;
        double d1 = this.m_20189_() + movement.vec().f_82481_;
        this.m_6034_(d2, d0, d1);
    }

    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        if (this.mover != null) {
            return this.mover.move(new MoverInfo(this.f_19797_, pos, vec, this));
        }
        return new ProjectileMovement(vec, this.rot());
    }

    public void setItem(ItemStack pStack) {
        this.stack = pStack;
        this.m_6210_();
    }

    public ItemStack m_7846_() {
        return this.stack;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.scale());
    }

    public boolean fullBright() {
        return true;
    }

    public float scale() {
        Item item;
        if (this.sizeCache == null && (item = this.m_7846_().m_41720_()) instanceof LaserItem) {
            LaserItem item2 = (LaserItem)item;
            this.sizeCache = Float.valueOf(item2.size);
        }
        return this.sizeCache == null ? 1.0f : this.sizeCache.floatValue();
    }

    @Override
    public void markErased(boolean kill) {
        if (!this.isErased) {
            super.markErased(kill);
        }
        this.isErased = true;
    }

    @Override
    public boolean isValid() {
        return !this.isErased && super.isValid();
    }

    @Override
    public void doGraze(Player entity) {
        if (this.f_19797_ < this.lastGraze) {
            return;
        }
        this.lastGraze = this.f_19797_ + 5;
        GrazeHelper.graze(entity, this);
    }

    @Override
    public void poof() {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        Item item = this.m_7846_().m_41720_();
        if (!(item instanceof LaserItem)) {
            return;
        }
        LaserItem item2 = (LaserItem)item;
        int col = item2.color.m_41071_();
        Vec3 pos = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        DanmakuParticleHelper.line(this.m_9236_(), pos, this.m_20156_(), col, this.length, this.m_20205_() / 2.0f, this.f_19796_);
    }
}

