/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.food;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.block.food.YHCakeBlock;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YHCandleCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Pair<Block, CakeBlock>, YHCandleCakeBlock> BY_CANDLE_AND_CAKE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    private final Supplier<YHCakeBlock> baseCake;
    public final Block candle;

    public static boolean hasEntry(Block candle, YHCakeBlock cake) {
        return BY_CANDLE_AND_CAKE.get(Pair.of((Object)candle, (Object)((Object)cake))) != null;
    }

    public static BlockState byCandle(Block candle, YHCakeBlock cake) {
        return BY_CANDLE_AND_CAKE.get(Pair.of((Object)candle, (Object)((Object)cake))).m_49966_();
    }

    public YHCandleCakeBlock(Supplier<YHCakeBlock> baseCake, Block candle, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
        this.baseCake = baseCake;
        this.candle = candle;
        BY_CANDLE_AND_CAKE.put((Pair<Block, CakeBlock>)Pair.of((Object)candle, (Object)((Object)baseCake.get())), this);
    }

    protected Iterable<Vec3> m_142199_(BlockState p_152868_) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState p_152875_, BlockGetter p_152876_, BlockPos p_152877_, CollisionContext p_152878_) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            if (YHCandleCakeBlock.candleHit(result) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                YHCandleCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            InteractionResult interactionresult = this.baseCake.get().eatSlice(level, pos, this.baseCake.get().m_49966_(), player);
            if (interactionresult.m_19077_()) {
                YHCandleCakeBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return interactionresult;
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.baseCake.get());
    }

    private static boolean candleHit(BlockHitResult result) {
        return result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT});
    }

    public BlockState m_7417_(BlockState state, Direction dire, BlockState sourceState, LevelAccessor level, BlockPos pos, BlockPos sourcePos) {
        return dire == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, dire, sourceState, level, pos, sourcePos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return CakeBlock.f_152743_;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

