/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.touhoulittlemaid.spell;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class MediumFairySpell
extends ActualSpellCard {
    @SerialClass.SerialField
    protected DyeColor primary = DyeColor.RED;
    @SerialClass.SerialField
    protected DyeColor secondary = DyeColor.BLUE;

    public MediumFairySpell init(DyeColor col, DyeColor sec) {
        this.primary = col;
        this.secondary = sec;
        return this;
    }

    @Override
    public void tick(CardHolder holder) {
        if (this.tick % 10 == 0) {
            int step = this.tick / 10;
            int round = step / 2 % 7;
            if (step % 2 == 0 && (round == 0 || round == 3)) {
                int n = (Integer)YHModConfig.COMMON.smallFairyStrength.get();
                int dur = 5 * (n + 2);
                double angle = 180.0 / (double)dur;
                this.addTicker(new Round().init(this.primary, YHDanmaku.Bullet.BALL, holder.forward(), round == 0 ? angle : -angle, 0.3 + (double)n * 0.1, dur));
            } else if (round == 1 || round == 4) {
                RandomSource r = holder.random();
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(holder.forward());
                int n = (Integer)YHModConfig.COMMON.smallFairyStrength.get();
                for (int i = -n; i <= n; ++i) {
                    for (int j = 0; j <= n; ++j) {
                        Vec3 dir = o.rotateDegrees(i * 15, r.m_216339_(-3, 3));
                        double v = 0.5 + (double)j * 0.3 - (double)n * 0.1;
                        Vec3 vel = dir.m_82490_(v);
                        int life = (int)(40.0 / v * (1.0 + r.m_188500_() * 0.5));
                        ItemDanmakuEntity e = holder.prepareDanmaku(life, vel, YHDanmaku.Bullet.CIRCLE, this.secondary);
                        holder.shoot(e);
                    }
                }
            }
        }
        super.tick(holder);
    }

    @SerialClass
    public static class Round
    extends Ticker<MediumFairySpell> {
        @SerialClass.SerialField
        private DyeColor color = DyeColor.RED;
        @SerialClass.SerialField
        private YHDanmaku.Bullet type = YHDanmaku.Bullet.BALL;
        @SerialClass.SerialField
        private double w = 3.0;
        @SerialClass.SerialField
        private double v = 0.5;
        @SerialClass.SerialField
        private int duration;
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);

        public Round init(DyeColor color, YHDanmaku.Bullet type, Vec3 dir, double w, double v, int duration) {
            this.color = color;
            this.type = type;
            this.dir = dir;
            this.w = w;
            this.v = v;
            this.duration = duration;
            return this;
        }

        @Override
        public boolean tick(CardHolder holder, MediumFairySpell card) {
            RandomSource r = holder.random();
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.dir);
            double hor = ((double)this.tick - (double)this.duration / 2.0) * this.w;
            Vec3 dir = o.rotateDegrees(hor, r.m_216339_(-3, 3));
            Vec3 vel = dir.m_82490_(this.v);
            int life = (int)(40.0 / this.v * (1.0 + r.m_188500_() * 0.5));
            ItemDanmakuEntity e = holder.prepareDanmaku(life, vel, this.type, this.color);
            holder.shoot(e);
            super.tick(holder, card);
            return this.tick >= this.duration;
        }
    }
}

