/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.jei;

import dev.xkmc.l2library.serial.recipe.BaseRecipeCategory;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.pot.table.item.VariantTableItemBase;
import dev.xkmc.youkaishomecoming.content.pot.table.recipe.CuisineRecipe;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;

public class CuisineRecipeCategory
extends BaseRecipeCategory<CuisineRecipe<?>, CuisineRecipeCategory> {
    private IGuiHelper guiHelper;
    private IDrawableStatic hand;

    public CuisineRecipeCategory() {
        super(YoukaisHomecoming.loc("cuisine"), (Class)Wrappers.cast(CuisineRecipe.class));
    }

    public CuisineRecipeCategory init(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createBlankDrawable(152, 36);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)YHBlocks.CUISINE_BOARD.asStack());
        this.hand = guiHelper.drawableBuilder(YoukaisHomecoming.loc("textures/gui/hand.png"), 0, 0, 16, 16).setTextureSize(32, 16).build();
        return this;
    }

    public Component getTitle() {
        return YHLangData.JEI_FERMENT.get(new Object[0]);
    }

    public void draw(CuisineRecipe<?> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int max = this.doRecipe(recipe, (ing, x, y) -> {
            if (ing.m_43947_()) {
                this.hand.draw(guiGraphics, x, y);
            }
        });
        IDrawableStatic recipeArrow = this.guiHelper.getRecipeArrow();
        recipeArrow.draw(guiGraphics, (max + 5) * 9 + 7, (36 - recipeArrow.getHeight()) / 2);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CuisineRecipe<?> recipe, IFocusGroup focuses) {
        int max = this.doRecipe(recipe, (ing, x, y) -> {
            if (!ing.m_43947_()) {
                builder.addInputSlot(x, y).setStandardSlotBackground().addIngredients(ing);
            }
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86 + max * 9, 10).setOutputSlotBackground().addItemStack(recipe.getResult());
    }

    private int doRecipe(CuisineRecipe<?> recipe, IngredientHandler handler) {
        int x;
        ArrayList<Ingredient> listBase = new ArrayList<Ingredient>();
        ArrayList<Ingredient> listRecipe = new ArrayList<Ingredient>(recipe.getCustomIngredients());
        VariantTableItemBase base = VariantTableItemBase.MAP.get(recipe.base());
        if (base != null) {
            base.collectIngredients(listBase, listRecipe);
        }
        int offset = (5 - listBase.size()) * 9;
        int index = 0;
        int y = 1;
        for (Ingredient ing : listBase) {
            x = index * 18 + 1 + offset;
            handler.draw(ing, x, y);
            ++index;
        }
        index = 0;
        offset = (5 - listRecipe.size()) * 9;
        y = base == null ? 10 : 19;
        for (Ingredient ing : listRecipe) {
            x = index * 18 + 1 + offset;
            handler.draw(ing, x, y);
            ++index;
        }
        return Math.max(listBase.size(), listRecipe.size());
    }

    private static interface IngredientHandler {
        public void draw(Ingredient var1, int var2, int var3);
    }
}

