/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.virtual;

import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.virtual.DanmakuClientHandler;
import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

@SerialClass
public class DanmakuToClientPacket
extends SerialPacketBase {
    @SerialClass.SerialField
    private Data[] entities;
    @SerialClass.SerialField
    private byte[] data;

    public DanmakuToClientPacket() {
    }

    public DanmakuToClientPacket(List<SimplifiedProjectile> list) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        this.entities = new Data[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Data dat;
            SimplifiedProjectile e = list.get(i);
            this.entities[i] = dat = new Data();
            dat.typeId = BuiltInRegistries.f_256780_.m_7447_((Object)e.m_6095_());
            dat.entityId = e.m_19879_();
            dat.posX = e.m_20185_();
            dat.posY = e.m_20186_();
            dat.posZ = e.m_20189_();
            dat.pitch = e.m_146909_();
            dat.yaw = e.m_146908_();
            Vec3 vec3d = e.m_20184_();
            dat.velX = vec3d.f_82479_;
            dat.velY = vec3d.f_82480_;
            dat.velZ = vec3d.f_82481_;
            e.writeSpawnData(data);
        }
        this.data = Arrays.copyOfRange(data.array(), 0, data.writerIndex());
        data.release();
    }

    public void handle(NetworkEvent.Context ctx) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])this.data);
        for (Data dat : this.entities) {
            Entity e;
            Optional type = BuiltInRegistries.f_256780_.m_203300_(dat.typeId);
            if (type.isEmpty() || !((e = DanmakuClientHandler.create((EntityType)((Holder.Reference)type.get()).m_203334_())) instanceof SimplifiedProjectile)) break;
            SimplifiedProjectile sp = (SimplifiedProjectile)e;
            dat.restore(e);
            sp.readSpawnData(new FriendlyByteBuf(buffer));
            DanmakuClientHandler.add(sp);
        }
        buffer.release();
    }

    @SerialClass
    public static class Data {
        @SerialClass.SerialField
        private int typeId;
        @SerialClass.SerialField
        private int entityId;
        @SerialClass.SerialField
        private double posX;
        @SerialClass.SerialField
        private double posY;
        @SerialClass.SerialField
        private double posZ;
        @SerialClass.SerialField
        private float pitch;
        @SerialClass.SerialField
        private float yaw;
        @SerialClass.SerialField
        private double velX;
        @SerialClass.SerialField
        private double velY;
        @SerialClass.SerialField
        private double velZ;

        public void restore(Entity e) {
            e.m_217006_(this.posX, this.posY, this.posZ);
            e.m_19890_(this.posX, this.posY, this.posZ, this.yaw, this.pitch);
            e.m_20234_(this.entityId);
            e.m_6001_(this.velX, this.velY, this.velZ);
        }
    }
}

