/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.type;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.BulkDataWriter;
import dev.xkmc.fastprojectileapi.render.core.DanmakuRenderStates;
import dev.xkmc.fastprojectileapi.render.core.DisplayType;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.fastprojectileapi.render.type.RenderableDanmakuType;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public record ButterflyProjectileType(ResourceLocation overlay, DisplayType display, int period) implements RenderableDanmakuType<ButterflyProjectileType, Ins>
{
    @Override
    public void start(MultiBufferSource buffer, List<Ins> list) {
        BulkDataWriter vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.danmaku(this.overlay, this.display())), list.size());
        for (Ins e : list) {
            e.tex(vc);
        }
        vc.flush();
    }

    @Override
    public void create(Consumer<Ins> holder, ProjectileRenderer<?> r, SimplifiedProjectile e, PoseStack pose, float pTick) {
        pose.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14179_((float)pTick, (float)e.f_19859_, (float)e.m_146908_())));
        pose.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)pTick, (float)e.f_19860_, (float)e.m_146909_())));
        float time = Math.abs(((float)e.f_19797_ + pTick) / (float)this.period % 1.0f * 4.0f - 2.0f) - 1.0f;
        float angle = 60.0f;
        int col = DanmakuRenderStates.fading(this.display, -1, r, e);
        pose.m_85836_();
        pose.m_252781_(Axis.f_252403_.m_252977_(time * angle));
        PoseStack.Pose mat = pose.m_85850_();
        Matrix4f m4 = new Matrix4f((Matrix4fc)mat.m_252922_());
        holder.accept(new Ins(m4, col, false));
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252781_(Axis.f_252403_.m_252977_(time * -angle));
        mat = pose.m_85850_();
        m4 = new Matrix4f((Matrix4fc)mat.m_252922_());
        holder.accept(new Ins(m4, col, true));
        pose.m_85849_();
    }

    public record Ins(Matrix4f m4, int color, boolean right) {
        public void tex(BulkDataWriter vc) {
            float x0 = 0.0f;
            float x1 = 0.5f;
            if (this.right) {
                x0 += 0.5f;
                x1 += 0.5f;
            }
            Ins.vertex(vc, this.m4, x1, 1.0f, x1, 0.0f, this.color);
            Ins.vertex(vc, this.m4, x1, 0.0f, x1, 1.0f, this.color);
            Ins.vertex(vc, this.m4, x0, 0.0f, x0, 1.0f, this.color);
            Ins.vertex(vc, this.m4, x0, 1.0f, x0, 0.0f, this.color);
        }

        private static void vertex(BulkDataWriter vc, Matrix4f m4, float x, float y, float u, float v, int color) {
            vc.addVertex(m4, x - 0.5f, 0.0f, y - 0.5f, u, v, color);
        }
    }
}

