/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.core;

import dev.xkmc.fastprojectileapi.render.core.ProjTypeHolder;
import dev.xkmc.fastprojectileapi.render.type.RenderableProjectileType;
import dev.xkmc.fastprojectileapi.render.virtual.ClientDanmakuCache;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="youkaishomecoming", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProjectileRenderHelper {
    private static RenderQueue QUEUE;

    public static void setup() {
        ProjTypeHolder.setup();
        QUEUE = new RenderQueue();
    }

    public static <T extends RenderableProjectileType<T, I>, I> Collection<I> setOf(ProjTypeHolder<T, I> key) {
        return QUEUE.setOf(key);
    }

    public static <T extends RenderableProjectileType<T, I>, I> void add(ProjTypeHolder<T, I> key, I ins) {
        ProjectileRenderHelper.setOf(key).add(ins);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.LevelTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != event.level || event.phase == TickEvent.Phase.START) {
            return;
        }
        ClientDanmakuCache cache = ClientDanmakuCache.get((Level)level);
        cache.tick();
    }

    @SubscribeEvent
    public static void renderLate(RenderLevelStageEvent event) {
        MultiBufferSource.BufferSource buffer;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            ClientDanmakuCache cache = ClientDanmakuCache.get((Level)level);
            cache.renderAll(event.getCamera(), event.getFrustum(), event.getPoseStack(), event.getPartialTick(), buffer);
            QUEUE.flush(buffer);
            buffer.m_173043_();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            QUEUE.flush(buffer);
            buffer.m_173043_();
        }
    }

    private static class RenderQueue {
        private final ArrayList<?>[] lists = new ArrayList[ProjTypeHolder.HOLDERS.size()];

        private RenderQueue() {
        }

        public <I> ArrayList<I> setOf(ProjTypeHolder<?, I> key) {
            if (this.lists[key.index] == null) {
                this.lists[key.index] = new ArrayList();
            }
            return (ArrayList)Wrappers.cast(this.lists[key.index]);
        }

        public void flush(MultiBufferSource.BufferSource buffer) {
            for (ArrayList<?> list : this.lists) {
                int i;
                this.lists[i] = null;
                if (list == null) continue;
                ProjTypeHolder.HOLDERS.get((int)i).type.start((MultiBufferSource)buffer, (List)Wrappers.cast(list));
            }
        }
    }
}

