/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.core;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.DisplayType;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public abstract class DanmakuRenderStates
extends RenderType {
    protected static final RenderStateShard.ShaderStateShard DANMAKU_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172820_);
    private static final BiFunction<ResourceLocation, DisplayType, RenderType> DANMAKU = Util.m_143821_((rl, type) -> DanmakuRenderStates.create("danmaku_" + type.getName(), rl, false, type));
    private static final BiFunction<ResourceLocation, DisplayType, RenderType> LASER = Util.m_143821_((rl, type) -> DanmakuRenderStates.create("laser_" + type.getName(), rl, true, type));

    public DanmakuRenderStates(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
    }

    private static RenderType create(String name, ResourceLocation tex, boolean cull, DisplayType type) {
        boolean bl = type != DisplayType.SOLID;
        RenderType.CompositeState.CompositeStateBuilder compositeStateBuilder = RenderType.CompositeState.m_110628_().m_173292_(DANMAKU_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(tex, false, false));
        return DanmakuRenderStates.m_173215_((String)name, (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)bl, (RenderType.CompositeState)compositeStateBuilder.m_110685_(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DisplayType.SOLID -> f_110134_;
            case DisplayType.TRANSPARENT -> f_110139_;
            case DisplayType.ADDITIVE -> f_110135_;
        }).m_110661_(cull ? f_110158_ : f_110110_).m_110691_(false));
    }

    public static RenderType danmaku(ResourceLocation rl, DisplayType type) {
        if (type == DisplayType.SOLID) {
            type = DisplayType.TRANSPARENT;
        }
        return DANMAKU.apply(rl, type);
    }

    public static RenderType laser(ResourceLocation rl, DisplayType type) {
        return LASER.apply(rl, type);
    }

    public static int fading(DisplayType display, int col, ProjectileRenderer<?> r, SimplifiedProjectile e) {
        double perc = r.fading(e);
        if (perc == 0.0) {
            return col;
        }
        int alpha = (int)((double)(col >>> 24) * perc);
        if (display == DisplayType.ADDITIVE) {
            return 0xFF000000 | alpha << 16 | alpha << 8 | alpha;
        }
        return alpha << 24 | col & 0xFFFFFF;
    }
}

