/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.EntityStorageCache;
import dev.xkmc.fastprojectileapi.collision.IEntityCache;
import dev.xkmc.fastprojectileapi.entity.BaseProjectile;
import dev.xkmc.fastprojectileapi.entity.EntityCachingUser;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ProjectileHitHelper {
    @Nullable
    public static HitResult getHitResultOnMoveVector(BaseProjectile e, boolean checkBlock) {
        Vec3 src = e.m_20182_();
        Vec3 v = e.m_20184_();
        Level level = e.m_9236_();
        Vec3 dst = src.m_82549_(v);
        BlockHitResult hit = null;
        if (checkBlock && (hit = level.m_45547_(new ClipContext(src, dst, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)e))).m_6662_() != HitResult.Type.MISS) {
            dst = hit.m_82450_();
        }
        if (level instanceof ServerLevel) {
            IEntityCache iEntityCache;
            ServerLevel sl = (ServerLevel)level;
            float radius = e.m_20205_() / 2.0f;
            float graze = e.grazeRange();
            AABB box = e.m_20191_().m_82369_(v);
            Entity entity = e.m_19749_();
            if (entity instanceof EntityCachingUser) {
                EntityCachingUser user = (EntityCachingUser)entity;
                iEntityCache = user.entityCache().get(sl, user.self());
            } else {
                iEntityCache = EntityStorageCache.get(sl);
            }
            EntityStorageCache cache = iEntityCache;
            List<Entity> list = cache.foreach(box.m_82400_((double)(1.0f + radius + graze)), e::canHitEntity);
            double d0 = Double.MAX_VALUE;
            Entity entity2 = null;
            for (Entity x : list) {
                if (x == e) continue;
                Vec3 hpos = ProjectileHitHelper.checkHit(x, e.alterHitBox(x, radius, 0.0f), src, dst);
                if (hpos != null) {
                    double d1 = src.m_82557_(hpos);
                    if (!(d1 < d0)) continue;
                    entity2 = x;
                    d0 = d1;
                    continue;
                }
                if (!(graze > 0.0f) || !(x instanceof Player)) continue;
                Player pl = (Player)x;
                Vec3 gr = ProjectileHitHelper.checkHit(x, e.alterHitBox(x, radius, graze), src, dst);
                if (gr == null) continue;
                e.doGraze(pl);
            }
            if (entity2 != null) {
                hit = new EntityHitResult(entity2);
            }
        }
        return hit;
    }

    @Nullable
    public static Vec3 checkHit(Entity e, AABB base, Vec3 src, Vec3 dst) {
        Vec3 vel = e.m_20184_();
        double speed = vel.m_82553_();
        int n = (int)Math.min(8.0, Math.floor(speed / 0.5));
        for (int i = 0; i <= n; ++i) {
            Optional optional;
            AABB aabb = n == 0 ? base : base.m_82383_(vel.m_82490_(1.0 * (double)i / (double)n));
            Optional optional2 = optional = aabb.m_82390_(src) ? Optional.of(src) : aabb.m_82371_(src, dst);
            if (!optional.isPresent()) continue;
            return (Vec3)optional.get();
        }
        return null;
    }
}

