/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.loader.forge;

import com.corosus.watut.WatutMod;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketNBTFromClient {
    private final CompoundTag nbt;

    public PacketNBTFromClient(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encode(PacketNBTFromClient msg, FriendlyByteBuf buffer) {
        buffer.m_130079_(msg.nbt);
    }

    public static PacketNBTFromClient decode(FriendlyByteBuf buffer) {
        return new PacketNBTFromClient(buffer.m_130260_());
    }

    public static class Handler {
        public static void handle(PacketNBTFromClient msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                try {
                    CompoundTag nbt = msg.nbt;
                    ServerPlayer playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (playerEntity != null) {
                        WatutMod.getPlayerStatusManagerServer().receiveAny((Player)playerEntity, nbt);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

