/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.data.WabTriggers;

public class SoarerJumpPacket {
    private final int gliderId;
    private final int flaps;

    public SoarerJumpPacket(int gliderId, int flaps) {
        this.gliderId = gliderId;
        this.flaps = flaps;
    }

    public SoarerJumpPacket(FriendlyByteBuf pBuffer) {
        this.gliderId = pBuffer.readInt();
        this.flaps = pBuffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.gliderId);
        buffer.writeInt(this.flaps);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        Entity entity = context.get().getSender().m_9236_().m_6815_(this.gliderId);
        if (entity instanceof Soarer) {
            Soarer soarer = (Soarer)entity;
            soarer.addFlaps(this.flaps);
            LivingEntity livingEntity = soarer.m_6688_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                WabTriggers.SOARER_FLYING_JUMP.m_222618_(player);
            }
        }
    }
}

