/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.assets;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.HangGlider;

public class WabItemGenerator
extends ItemModelProvider {
    public WabItemGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "wan_ancient_beasts", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem(WabItems.CHISEL);
        this.basicItem(WabItems.QUICK_SAND_BUCKET);
        this.basicItem(WabItems.QUICK_RED_SAND_BUCKET);
        this.basicItem(WabItems.EATER_TOOTH);
        this.basicItem(WabBlocks.CRUSHER_SPIKE);
        this.basicItem(WabItems.GLIDER_FEATHER);
        this.basicItem(WabItems.ANCIENT_UPGRADE_SMITHING_TEMPLATE);
        this.basicItem(WabItems.FROZEN_ANCIENT_MEAT);
        this.basicItem(WabItems.RAW_ANCIENT_MEAT);
        this.basicItem(WabItems.COOKED_ANCIENT_MEAT);
        this.basicItem(WabItems.TOXLACANTH);
        this.basicItem(WabItems.COOKED_TOXLACANTH);
        this.basicItem(WabItems.TOXLACANTH_BUCKET);
        this.basicItem(WabItems.SNIFF_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.basicItem(WabItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.basicItem(WabItems.JAW_POTTERY_SHERD);
        this.basicItem(WabItems.SPIKE_POTTERY_SHERD);
        this.basicItem(WabItems.STROLL_POTTERY_SHERD);
        this.basicItem(WabItems.BEAK_POTTERY_SHERD);
        this.basicItem(WabItems.FALL_POTTERY_SHERD);
        this.basicItem(WabItems.FOSSIL_POTTERY_SHERD);
        this.spawnEgg(WabItems.EATER_SPAWN_EGG);
        this.spawnEgg(WabItems.WALKER_SPAWN_EGG);
        this.spawnEgg(WabItems.CRUSHER_SPAWN_EGG);
        this.spawnEgg(WabItems.GLIDER_SPAWN_EGG);
        this.spawnEgg(WabItems.SOARER_SPAWN_EGG);
        this.spawnEgg(WabItems.PALEONTOLOGIST_SPAWN_EGG);
        this.spawnEgg(WabItems.TOXLACANTH_SPAWN_EGG);
        this.basicItem(WabBlocks.EATER_EGG);
        this.basicItem(WabBlocks.WALKER_EGG);
        this.basicItem(WabBlocks.CRUSHER_EGG);
        this.basicItem(WabBlocks.GLIDER_EGG);
        this.basicItem(WabBlocks.SOARER_EGG);
        this.basicItem(WabBlocks.NEST);
        this.block(WabBlocks.SUSPICIOUS_RED_SAND, this.blockResource("suspicious_red_sand_0"));
        this.block(WabBlocks.SUSPICIOUS_ICE, this.blockResource("suspicious_ice_0"));
        this.block(WabBlocks.FROZEN_STRAW_BLOCK);
        this.block(WabBlocks.STRAW_BLOCK);
        this.block(WabBlocks.STRAW_STAIRS);
        this.block(WabBlocks.STRAW_SLAB);
        this.block(WabBlocks.SNIFFER_SKULL);
        this.block(WabBlocks.EATER_SKULL);
        this.block(WabBlocks.WALKER_SKULL);
        this.block(WabBlocks.CRUSHER_SKULL);
        this.block(WabBlocks.GLIDER_SKULL);
        this.block(WabBlocks.SOARER_SKULL);
        this.block(WabBlocks.CHARGER_SKULL);
        this.hangGlider(WabItems.HANG_GLIDER);
        this.hangGlider(WabItems.WHITE_HANG_GLIDER);
        this.hangGlider(WabItems.LIGHT_GRAY_HANG_GLIDER);
        this.hangGlider(WabItems.GRAY_HANG_GLIDER);
        this.hangGlider(WabItems.BLACK_HANG_GLIDER);
        this.hangGlider(WabItems.BROWN_HANG_GLIDER);
        this.hangGlider(WabItems.RED_HANG_GLIDER);
        this.hangGlider(WabItems.ORANGE_HANG_GLIDER);
        this.hangGlider(WabItems.YELLOW_HANG_GLIDER);
        this.hangGlider(WabItems.LIME_HANG_GLIDER);
        this.hangGlider(WabItems.GREEN_HANG_GLIDER);
        this.hangGlider(WabItems.LIGHT_BLUE_HANG_GLIDER);
        this.hangGlider(WabItems.CYAN_HANG_GLIDER);
        this.hangGlider(WabItems.BLUE_HANG_GLIDER);
        this.hangGlider(WabItems.PURPLE_HANG_GLIDER);
        this.hangGlider(WabItems.MAGENTA_HANG_GLIDER);
        this.hangGlider(WabItems.PINK_HANG_GLIDER);
    }

    public ItemModelBuilder basicItem(RegistryObject<?> item) {
        return this.basicItem(item, this.resource(item.getId().m_135815_()));
    }

    public ItemModelBuilder basicItem(RegistryObject<?> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", texture);
    }

    public ItemModelBuilder block(RegistryObject<? extends Block> block) {
        return this.block(block, WanAncientBeasts.resource("block/" + block.getId().m_135815_()));
    }

    public ItemModelBuilder block(RegistryObject<? extends Block> block, ResourceLocation parent) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), parent);
    }

    public ItemModelBuilder spawnEgg(RegistryObject<ForgeSpawnEggItem> egg) {
        return (ItemModelBuilder)this.withExistingParent(egg.getId().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
    }

    public ItemModelBuilder hangGlider(RegistryObject<HangGlider> hangGlider) {
        return this.basicItem(hangGlider).override().predicate(new ResourceLocation("hanging"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(this.resource(hangGlider.getId().m_135815_() + "_hanging"), this.existingFileHelper)).end();
    }

    private ResourceLocation resource(String name) {
        return WanAncientBeasts.resource("item/" + name);
    }

    private ResourceLocation blockResource(String name) {
        return WanAncientBeasts.resource("block/" + name);
    }
}

