/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.fly;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FlyFollowOwnerGoal
extends Goal {
    private final TamableAnimal mob;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public FlyFollowOwnerGoal(TamableAnimal mob, double pSpeedModifier, float pStartDistance, float pStopDistance) {
        this.mob = mob;
        this.level = mob.m_9236_();
        this.speedModifier = pSpeedModifier;
        this.navigation = mob.m_21573_();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_269323_();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.mob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.mob.m_21827_() || this.mob.m_20159_() || this.mob.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.mob.m_20280_((Entity)this.owner) >= 1024.0) {
                this.teleportToOwner();
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-5, 5);
            int k = this.randomIntInclusive(-3, 3);
            int l = this.randomIntInclusive(-5, 5);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 3.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 3.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.mob.m_7678_((double)pX + 0.5, (double)pY, (double)pZ + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)this.mob.m_20183_());
        return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.mob.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

