/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class QuickSandCapability {
    public static final String TICK_IN_QUICKSAND_KEY = "tick_in_quicksand";
    public static final String LAST_TICK_IN_QUICKSAND_KEY = "last_tick_in_quicksand";
    private int tickInQuicksand;
    private long lastTickInQuicksand;

    public long getLastTickInQuicksand() {
        return this.lastTickInQuicksand;
    }

    public void addTickInQuicksand(long tick) {
        this.tickInQuicksand = Math.max(this.getTickInQuicksand(tick) + 2, 1);
        this.lastTickInQuicksand = tick;
    }

    public int getTickInQuicksand(long tick) {
        return this.tickInQuicksand - Math.max((int)(tick - this.lastTickInQuicksand), 0);
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_(TICK_IN_QUICKSAND_KEY, this.tickInQuicksand);
        nbt.m_128356_(LAST_TICK_IN_QUICKSAND_KEY, this.lastTickInQuicksand);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.tickInQuicksand = nbt.m_128451_(TICK_IN_QUICKSAND_KEY);
        this.lastTickInQuicksand = nbt.m_128454_(LAST_TICK_IN_QUICKSAND_KEY);
    }
}

