/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.ribs.vintagedelight.block.ModBlocks;
import net.ribs.vintagedelight.worldgen.tree.ModTrunkPlacerTypes;

public class VineTrunkPlacer
extends TrunkPlacer {
    public static final Codec<VineTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> VineTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, VineTrunkPlacer::new));

    public VineTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.VINE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos startPos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos.MutableBlockPos mutablePos = startPos.m_122032_();
        int height = this.m_226153_(random);
        BlockPos topPosition = null;
        for (int y = 0; y < height; ++y) {
            int thickness = this.calculateThickness(y, height);
            int xOffset = this.calculateOffset(y, height, random);
            int zOffset = this.calculateOffset(y, height, random);
            if (thickness >= 1) {
                for (int x = -thickness; x <= thickness; ++x) {
                    for (int z = -thickness; z <= thickness; ++z) {
                        if (x * x + z * z > thickness * thickness) continue;
                        mutablePos.m_122178_(startPos.m_123341_() + xOffset + x, startPos.m_123342_() + y, startPos.m_123343_() + zOffset + z);
                        this.m_226187_(level, blockSetter, random, (BlockPos)mutablePos, config);
                    }
                }
            } else {
                mutablePos.m_122178_(startPos.m_123341_() + xOffset, startPos.m_123342_() + y, startPos.m_123343_() + zOffset);
                this.m_226187_(level, blockSetter, random, (BlockPos)mutablePos, config);
            }
            if (y != height - 1) continue;
            topPosition = mutablePos.m_7949_();
        }
        if (topPosition != null && (double)random.m_188501_() < 0.8) {
            BlockState goldBlockState = ((Block)ModBlocks.GOLDEN_EGG.get()).m_49966_();
            blockSetter.accept(topPosition, goldBlockState);
        }
        return foliageAttachments;
    }

    private int calculateThickness(int currentHeight, int maxHeight) {
        double stage1 = 0.4 * (double)maxHeight;
        double stage2 = 0.6 * (double)maxHeight;
        double stage3 = 0.8 * (double)maxHeight;
        if ((double)currentHeight < stage1) {
            return 2;
        }
        if ((double)currentHeight < stage2) {
            return 1;
        }
        if ((double)currentHeight < stage3) {
            return 1;
        }
        return 0;
    }

    private int calculateOffset(int currentHeight, int maxHeight, RandomSource random) {
        double windinessFactor = 0.3;
        int maxOffset = 4;
        double frequency = 3.0;
        return (int)(Math.sin((double)currentHeight / (double)maxHeight * Math.PI * frequency) * (double)maxOffset * windinessFactor);
    }
}

