/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.ribs.vintagedelight.block.ModBlocks;
import net.ribs.vintagedelight.block.custom.SaltLayerBlock;

public class SaltBlock
extends Block {
    private final float growthSpeed;

    public SaltBlock(BlockBehaviour.Properties properties, float growthSpeed) {
        super(properties.m_60978_(0.5f).m_60918_(SoundType.f_56746_).m_60977_());
        this.growthSpeed = growthSpeed;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (!world.f_46443_ && random.m_188501_() < this.calculateGrowthProbability()) {
            this.checkAndGrowSaltLayer(world, pos);
        }
    }

    private float calculateGrowthProbability() {
        return Math.min(1.0f, this.growthSpeed / 100.0f);
    }

    private boolean hasWaterAround(LevelReader world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            if (direction == Direction.UP || direction == Direction.DOWN || !world.m_6425_(adjacentPos = pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    private void checkAndGrowSaltLayer(ServerLevel world, BlockPos pos) {
        boolean isWaterNearby = this.hasWaterAround((LevelReader)world, pos);
        BlockPos abovePos = pos.m_7494_();
        if (isWaterNearby && world.m_46859_(abovePos) || this.canGrowSaltLayer(world, abovePos)) {
            BlockState aboveState = world.m_8055_(abovePos);
            if (aboveState.m_60713_((Block)ModBlocks.SALT_LAYER.get())) {
                int layers = (Integer)aboveState.m_61143_((Property)SaltLayerBlock.f_56581_);
                if (layers < 8) {
                    world.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)SaltLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1)), 3);
                }
            } else {
                world.m_7731_(abovePos, (BlockState)((Block)ModBlocks.SALT_LAYER.get()).m_49966_().m_61124_((Property)SaltLayerBlock.f_56581_, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    private boolean canGrowSaltLayer(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60713_((Block)ModBlocks.SALT_LAYER.get()) && (Integer)state.m_61143_((Property)SaltLayerBlock.f_56581_) < 8;
    }
}

