/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.ribs.vintagedelight.block.ModBlocks;
import net.ribs.vintagedelight.block.entity.ModBlockEntities;
import net.ribs.vintagedelight.item.ModCreativeModTabs;
import net.ribs.vintagedelight.item.ModItems;
import net.ribs.vintagedelight.mobEffects.CustomPotionBrewing;
import net.ribs.vintagedelight.mobEffects.ModPotions;
import net.ribs.vintagedelight.mobEffects.VDModEffects;
import net.ribs.vintagedelight.recipe.ModRecipes;
import net.ribs.vintagedelight.screen.FermentingJarScreen;
import net.ribs.vintagedelight.screen.ModMenuTypes;
import net.ribs.vintagedelight.worldgen.tree.ModTrunkPlacerTypes;

@Mod(value="vintagedelight")
public class VintageDelight {
    public static final String MODID = "vintagedelight";

    public VintageDelight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ModCreativeModTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModTrunkPlacerTypes.register(modEventBus);
        VDModEffects.MOB_EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModPotions.POTIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PEANUT.get()), 0.4f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.GEARO_BERRY_ITEM.get()), 0.4f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.GHOST_PEPPER.get()), 0.4f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.GHOST_PEPPER_SEEDS.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CUCUMBER.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CUCUMBER_SEEDS.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.OAT_SEEDS.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLE.get()), 0.4f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLED_PEPPER.get()), 0.4f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLED_BEETROOT.get()), 0.6f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLED_EGG.get()), 0.6f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLED_ONION.get()), 0.6f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PICKLED_PITCHER_POD.get()), 0.6f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CENTURY_EGG.get()), 0.9f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModBlocks.MAGIC_PEANUT.get()), 0.85f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.OAT.get()), 0.3f);
            VintageDelight.registerItemSetAdditions();
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CustomPotionBrewing.addMix(Potions.f_43602_, (Item)ModItems.SALT_DUST.get(), (Potion)ModPotions.DEHYDRATED_POTION.get());
            CustomPotionBrewing.addMix((Potion)ModPotions.DEHYDRATED_POTION.get(), Items.f_42451_, (Potion)ModPotions.LONG_DEHYDRATED_POTION.get());
            CustomPotionBrewing.addMix((Potion)ModPotions.DEHYDRATED_POTION.get(), Items.f_42525_, (Potion)ModPotions.STRONG_DEHYDRATED_POTION.get());
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void registerItemSetAdditions() {
        Ingredient newChickenFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GHOST_PEPPER_SEEDS.get(), (ItemLike)ModItems.CUCUMBER_SEEDS.get(), (ItemLike)ModItems.OAT_SEEDS.get()});
        Chicken.f_28233_ = new CompoundIngredient(Arrays.asList(Chicken.f_28233_, newChickenFood)){};
        Ingredient newPigFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CUCUMBER.get(), (ItemLike)ModItems.GHOST_PEPPER.get(), (ItemLike)ModItems.RAW_OAT.get(), (ItemLike)ModItems.PEANUT.get()});
        Pig.f_29458_ = new CompoundIngredient(Arrays.asList(Pig.f_29458_, newPigFood)){};
        Collections.addAll(Parrot.f_29357_, (Item)ModItems.GHOST_PEPPER_SEEDS.get(), (Item)ModItems.CUCUMBER_SEEDS.get(), (Item)ModItems.OAT_SEEDS.get());
        HashSet newWantedItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.GHOST_PEPPER.get(), (Item)ModItems.CUCUMBER.get(), (Item)ModItems.PEANUT.get(), (Item)ModItems.OAT.get()});
        newWantedItems.addAll(Villager.f_35372_);
        Villager.f_35372_ = ImmutableSet.copyOf((Collection)newWantedItems);
    }

    @Mod.EventBusSubscriber(modid="vintagedelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FERMENTING_MENU.get()), FermentingJarScreen::new);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FERMENTING_JAR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAGIC_PEANUT.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OAT_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILD_OATS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GEARO_BERRY_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PEANUT_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILD_PEANUTS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GHOST_PEPPER_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILD_GHOST_PEPPERS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CUCUMBER_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILD_CUCUMBERS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.EMPTY_MASON_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PEPPER_JAM_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GEARO_BERRY_JAM_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SWEET_BERRY_JAM_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GLOW_BERRY_JAM_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.APPLE_SAUCE_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.NUT_MASH_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RELISH_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.VINEGAR_JAR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HONEY_JAR.get()), (RenderType)RenderType.m_110463_());
        }
    }
}

