/*
 * Decompiled with CFR 0.152.
 */
package de.chrisimo.vegandelight;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeManipulation {
    private static final Logger logger = LoggerFactory.getLogger((String)"Vegan Delight/recipe modifiers");
    private static final Map<Item, Ingredient.Value> registeredSubstitutes = new HashMap<Item, Ingredient.Value>();

    static void load(@NotNull RecipeManager recipeManager) {
        Collection allRecipes = recipeManager.m_44051_();
        logger.info("Scanning {} recipes for modification", (Object)allRecipes.size());
        AtomicInteger ingredientsChanged = new AtomicInteger();
        for (Recipe recipe : allRecipes) {
            NonNullList ingredients = recipe.m_7527_();
            for (Ingredient ingredient : ingredients) {
                registeredSubstitutes.forEach((item, substitute) -> {
                    boolean wasChanged = RecipeManipulation.modifyIngredient(ingredient, item, substitute);
                    if (wasChanged) {
                        ingredientsChanged.getAndIncrement();
                    }
                });
            }
        }
        logger.info("Modified {} recipe ingredients", (Object)ingredientsChanged);
    }

    private static boolean modifyIngredient(@NotNull Ingredient ingredient, Item item, Ingredient.Value substitute) {
        for (ItemStack stack : ingredient.m_43908_()) {
            if (!stack.m_150930_(item) || RecipeManipulation.isSubstituteAlreadyUsable(ingredient, substitute)) continue;
            RecipeManipulation.addSubstitute(ingredient, substitute);
            return true;
        }
        return false;
    }

    private static boolean isSubstituteAlreadyUsable(Ingredient ingredient, @NotNull Ingredient.Value substitute) {
        for (ItemStack item : substitute.m_6223_()) {
            if (!ingredient.test(item)) continue;
            return true;
        }
        return false;
    }

    private static void addSubstitute(@NotNull Ingredient ingredient, Ingredient.Value substitute) {
        ingredient.f_43902_ = Arrays.copyOf(ingredient.f_43902_, ingredient.f_43902_.length + 1);
        ingredient.f_43902_[ingredient.f_43902_.length - 1] = substitute;
        ingredient.f_43904_ = null;
        ingredient.f_43903_ = null;
    }

    public static void registerSubstitute(Item item, Ingredient.Value substitute) {
        registeredSubstitutes.put(item, substitute);
    }

    public static void registerSubstitute(Item item, Item substitute) {
        RecipeManipulation.registerSubstitute(item, (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)substitute)));
    }
}

