/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import untamedwilds.UntamedWilds;

public class JSONLoader<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private final Codec<T> codec;
    private final String folderName;
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();

    public JSONLoader(String folderName, Codec<T> codec) {
        this(folderName, codec, STANDARD_GSON);
    }

    public JSONLoader(String folderName, Codec<T> codec, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
    }

    @Nullable
    public T getData(ResourceLocation id) {
        return this.data.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        UntamedWilds.LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        UntamedWilds.LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
    }

    private Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> newMap.put(key, result.getFirst())).ifRight(partial -> UntamedWilds.LOGGER.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        return newMap;
    }
}

