/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item.debug;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.TimeUtils;

public class AnalyzerItem
extends Item {
    public AnalyzerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Level world = target.m_9236_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (target instanceof ComplexMob) {
            ComplexMob entity = (ComplexMob)target;
            String entityName = entity instanceof ISpecies ? ((ISpecies)((Object)entity)).getSpeciesName() : entity.m_7755_().getString();
            playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Diagnose: " + (String)((Boolean)ConfigGamerules.genderedBreeding.get() != false ? entity.getGenderString() + " " : "") + entityName + " (Skin: " + entity.getSkin() + ") (Eco Level: " + ComplexMob.getEcoLevel((LivingEntity)entity) + ") " + entity.m_21223_() + "/" + entity.m_21233_() + " HP")));
            if (((Boolean)ConfigGamerules.scientificNames.get()).booleanValue()) {
                String useVarName = entity instanceof ISpecies ? "_" + ((ISpecies)((Object)entity)).getRawSpeciesName(entity.getVariant()) : "";
                playerIn.m_213846_((Component)Component.m_237115_((String)(entity.m_6095_().m_20675_() + useVarName + ".sciname")).m_130940_(ChatFormatting.ITALIC));
            }
            if (target instanceof ComplexMobTerrestrial) {
                playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Hunger: " + ((ComplexMobTerrestrial)entity).getHunger() + "/100 Hunger")));
            }
            if (!entity.isMale() && entity.m_146764_() > 0 && !((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue()) {
                playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("This female will give birth in " + TimeUtils.convertTicksToDays(world, entity.m_146764_()) + " (" + entity.m_146764_() + " ticks)")));
            }
            if (entity.wantsToBreed()) {
                playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("This mob is looking for a suitable mate")));
            }
            if (entity.m_6162_()) {
                playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("This mob will grow up in " + TimeUtils.convertTicksToDays(world, entity.m_146764_() * -1) + " (" + entity.m_146764_() * -1 + " ticks)")));
            }
            return InteractionResult.SUCCESS;
        }
        playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Diagnose: " + target.m_7755_().getString() + " " + target.m_21223_() + "/" + target.m_21233_() + " HP (Eco Level: " + ComplexMob.getEcoLevel(target) + ")")));
        if (target.m_6162_() && target instanceof AgeableMob) {
            AgeableMob entity = (AgeableMob)target;
            playerIn.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("This mob will grow up in " + TimeUtils.convertTicksToDays(world, entity.m_146764_() * -1) + " (" + entity.m_146764_() * -1 + " ticks)")));
        }
        return InteractionResult.SUCCESS;
    }
}

