/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.item.IPopulated;
import untamedwilds.util.EntityUtils;

public class MobEggItem
extends Item
implements IPopulated {
    private final Supplier<? extends EntityType<?>> entity;

    public MobEggItem(Supplier<? extends EntityType<?>> typeIn, Item.Properties properties) {
        super(properties);
        this.entity = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"mobspawn.tooltip.unknown").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        Level worldIn = useContext.m_43725_();
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useContext.m_43722_();
        BlockPos pos = useContext.m_8083_();
        Direction facing = useContext.m_43719_();
        BlockState blockState = worldIn.m_8055_(pos);
        BlockPos spawnPos = blockState.m_60812_((BlockGetter)worldIn, pos).m_83281_() ? pos : pos.m_121945_(facing);
        EntityType<?> entity = EntityUtils.getEntityTypeFromTag(itemStack.m_41783_(), this.entity.get());
        Entity spawn = entity.m_262451_((ServerLevel)worldIn, itemStack.m_41783_(), null, spawnPos, MobSpawnType.BUCKET, true, !Objects.equals(pos, spawnPos) && facing == Direction.UP);
        if (spawn instanceof ComplexMob) {
            ComplexMob entitySpawn = (ComplexMob)spawn;
            entitySpawn.setVariant(this.getSpecies(itemStack, entitySpawn));
            entitySpawn.chooseSkinForSpecies(entitySpawn, true);
            entitySpawn.setRandomMobSize();
            entitySpawn.setGender(entitySpawn.m_217043_().m_188503_(2));
            entitySpawn.m_146762_(entitySpawn.getAdulthoodTime() * -1);
            if (spawn instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)spawn).updateAttributes();
            }
        }
        if (spawn != null) {
            ((ServerLevel)worldIn).m_47205_(spawn);
        }
        itemStack.m_41774_(1);
        return InteractionResult.CONSUME;
    }

    public String m_5524_() {
        return Component.m_237115_((String)("item.untamedwilds.egg_" + this.entity.get().m_204041_().m_205785_().m_135782_().m_135815_())).getString();
    }

    private int getSpecies(ItemStack itemIn, ComplexMob entityIn) {
        if (itemIn.m_41783_() != null && itemIn.m_41783_().m_128441_("variant")) {
            return itemIn.m_41783_().m_128451_("variant");
        }
        return entityIn.getVariant();
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output group) {
        for (int i = 0; i < EntityUtils.getNumberOfSpecies(this.entity.get()); ++i) {
            CompoundTag baseTag = new CompoundTag();
            ItemStack item = new ItemStack((ItemLike)this);
            baseTag.m_128405_("variant", i);
            baseTag.m_128405_("CustomModelData", i);
            item.m_41751_(baseTag);
            group.m_246342_(item);
        }
    }
}

