/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartPanicGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityWildebeest
extends ComplexMobTerrestrial
implements INewSkins,
ISpecies,
IPackEntity {
    public static Animation IDLE_TALK;
    public static Animation IDLE_SHAKE;
    public static Animation HOP;
    public static Animation EAT;

    public EntityWildebeest(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        IDLE_TALK = Animation.create((int)20);
        IDLE_SHAKE = Animation.create((int)80);
        HOP = Animation.create((int)30);
        EAT = Animation.create((int)76);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new SmartPanicGoal((PathfinderMob)this, 2.3, true));
        this.f_21345_.m_25352_(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityWildebeest.getEcoLevel(input) > EntityWildebeest.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new GrazeGoal(this, 10));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityWildebeest) && EntityWildebeest.getEcoLevel(input) > EntityWildebeest.getEcoLevel((LivingEntity)this)));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.f_146733_ == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            int i;
            if (this.herd == null) {
                IPackEntity.initPack(this);
            } else {
                this.herd.tick();
            }
            if (this.m_6113_() > 0.24f && this.getAnimation() == NO_ANIMATION && !this.m_21573_().m_26571_()) {
                this.setAnimation(HOP);
            }
            if (this.m_9236_().m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if ((i = this.f_19796_.m_188503_(3000)) == 13 && !this.m_20069_() && this.m_5448_() == null && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.isSitting()) {
                this.setSitting(false);
            }
            if (i > 2960 && !this.m_6162_()) {
                this.setAnimation(i % 2 == 0 ? IDLE_SHAKE : IDLE_TALK);
            }
            if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
            }
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
        }
        return flag;
    }

    private Animation chooseAttackAnimation() {
        return NO_ANIMATION;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    @Nullable
    public EntityWildebeest getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityWildebeest((EntityType<? extends ComplexMob>)((EntityType)ModEntity.WILDEBEEST.get()), this.m_9236_()));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.m_9236_().m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_217043_().m_188503_(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, IDLE_TALK, IDLE_SHAKE, HOP, EAT};
    }

    @Override
    public Animation getAnimationEat() {
        return EAT;
    }
}

