/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.FollowParentGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.AngrySleeperTarget;
import untamedwilds.entity.ai.target.GuardPositionTarget;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartHurtByTargetGoal;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.entity.ai.unique.BearRaidChestsGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityBear
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> SHORT_SNOUT = SynchedEntityData.m_135353_(EntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACK_HUMP = SynchedEntityData.m_135353_(EntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_BITE;
    public static Animation ATTACK_MAUL;
    public static Animation ATTACK_SWIPE;
    public static Animation ATTACK_POUND;
    public static Animation ANIMATION_ROAR;
    public static Animation IDLE_STAND;
    public static Animation IDLE_TALK;
    public static Animation ANIMATION_EAT;

    public EntityBear(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(SHORT_SNOUT, (Object)false);
        this.f_19804_.m_135372_(BACK_HUMP, (Object)false);
        ANIMATION_ROAR = Animation.create((int)50);
        IDLE_TALK = Animation.create((int)20);
        IDLE_STAND = Animation.create((int)148);
        ANIMATION_EAT = Animation.create((int)104);
        ATTACK_BITE = Animation.create((int)18);
        ATTACK_MAUL = Animation.create((int)76);
        ATTACK_SWIPE = Animation.create((int)26);
        ATTACK_POUND = Animation.create((int)28);
        this.turn_speed = 0.3f;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal(this, 12));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 2.3, false, 1.0f));
        this.f_21345_.m_25352_(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityBear.getEcoLevel(input) > EntityBear.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(4, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new BearRaidChestsGoal(this, 20));
        this.f_21345_.m_25352_(6, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new SmartHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityBear)));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityBear.getEcoLevel(input) < EntityBear.getEcoLevel((LivingEntity)this)));
        this.f_21346_.m_25352_(4, new AngrySleeperTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80) {
            if (((Boolean)ConfigGamerules.hardcoreBreeding.get()).booleanValue()) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
                return list.size() < 3;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntityBear getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityBear((EntityType<? extends ComplexMob>)((EntityType)ModEntity.BEAR.get()), this.m_9236_()));
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 1000 == 0) {
                this.addHunger(-2);
                if (!this.isStarving()) {
                    this.m_5634_(2.0f);
                }
            }
            if (this.m_21223_() < this.m_21233_() / 2.0f) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0, true, true));
                this.forceSleep = -1200;
            }
            this.setAngry(this.m_5448_() != null);
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_() && this.getCommandInt() == 0) {
                int i = this.f_19796_.m_188503_(3000);
                if (i == 0 && !this.m_20069_() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                }
                if ((i == 1 || this.m_20069_()) && this.isSitting() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                }
                if (i == 2 && this.canMove() && !this.m_20069_() && !this.m_6162_() && !this.isSitting()) {
                    this.setAnimation(IDLE_STAND);
                }
                if (i > 2980 && !this.m_20069_() && !this.m_6162_()) {
                    this.setAnimation(IDLE_TALK);
                }
            }
        }
        if (this.f_19797_ % 100 == 0 && this.m_5448_() != null && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() != NO_ANIMATION) {
            if (this.getAnimation() == ATTACK_BITE && this.getAnimationTick() == 1) {
                this.m_5496_(ModSounds.ENTITY_ATTACK_BITE, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_SWIPE && this.getAnimationTick() == 8) {
                this.m_5496_(SoundEvents.f_12317_, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_POUND && this.getAnimationTick() == 10) {
                this.m_21566_().m_24988_(2.0f, 0.0f);
                this.m_5496_(SoundEvents.f_12317_, 1.5f, 0.8f);
            }
            if (this.getAnimation() == ATTACK_MAUL) {
                if (this.getAnimationTick() == 10) {
                    this.m_5496_(this.getThreatSound(), this.m_6121_(), this.m_6100_());
                }
                if (this.getAnimationTick() == 20) {
                    this.m_5496_(SoundEvents.f_12276_, 1.5f, 0.8f);
                    if (!this.m_9236_().m_5776_()) {
                        BlockPos pos = this.m_20183_().m_7495_();
                        BlockState state = this.m_9236_().m_8055_(pos);
                        if (!state.addLandingEffects((ServerLevel)this.m_9236_(), pos, state, (LivingEntity)this, 40)) {
                            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_(), this.m_20186_(), this.m_20189_(), 40, 0.0, 0.0, 0.0, (double)99.3f);
                        }
                    }
                }
            }
            if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 7) {
                this.m_5496_(this.getThreatSound(), this.m_6121_(), this.m_6100_());
            }
            if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1) {
                this.m_5496_(ModSounds.ENTITY_BEAR_AMBIENT, this.m_6121_(), this.m_6100_());
            }
            if (this.getAnimation() == ANIMATION_EAT && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20 || this.getAnimationTick() == 30)) {
                this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            }
        }
        super.m_8107_();
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, new GuardPositionTarget<LivingEntity>(this, LivingEntity.class, true, input -> !input.m_21224_()));
            this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public double getMountedYOffset() {
        return this.getModelScale() + 0.5f * this.getMobSize();
    }

    @Override
    protected SoundEvent m_7515_() {
        return !this.m_6162_() ? super.m_7515_() : ModSounds.ENTITY_BEAR_BABY_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return !this.m_6162_() ? super.m_7975_(source) : ModSounds.ENTITY_BEAR_BABY_CRY;
    }

    @Override
    protected SoundEvent m_5592_() {
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
            this.setAnimationTick(0);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.performRetaliation(damageSource, this.m_21223_(), amount, false);
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_269533_(DamageTypeTags.f_273918_);
    }

    private Animation chooseAttackAnimation() {
        return switch (this.f_19796_.m_188503_(4)) {
            case 0 -> ATTACK_SWIPE;
            case 1 -> ATTACK_BITE;
            case 2 -> ATTACK_MAUL;
            default -> ATTACK_POUND;
        };
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.85f;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.m_9236_().m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_217043_().m_188503_(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Animation getAnimationEat() {
        return ANIMATION_EAT;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_ROAR, IDLE_STAND, IDLE_TALK, ANIMATION_EAT, ATTACK_MAUL, ATTACK_BITE, ATTACK_SWIPE, ATTACK_POUND};
    }

    public boolean isPanda() {
        return EntityBear.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "isPanda") == 1;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityBear.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityBear.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
        this.setShortSnout(EntityBear.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "hasShortSnout") == 1);
        this.setHump(EntityBear.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "hasHump") == 1);
    }

    public boolean hasShortSnout() {
        return (Boolean)this.f_19804_.m_135370_(SHORT_SNOUT);
    }

    private void setShortSnout(boolean short_snout) {
        this.f_19804_.m_135381_(SHORT_SNOUT, (Object)short_snout);
    }

    public boolean hasHump() {
        return (Boolean)this.f_19804_.m_135370_(BACK_HUMP);
    }

    private void setHump(boolean hump) {
        this.f_19804_.m_135381_(BACK_HUMP, (Object)hump);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.m_20186_() < 53.0) {
            this.setVariant(1);
        }
        return data;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasShortSnout", this.hasShortSnout());
        compound.m_128379_("hasHump", this.hasHump());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setShortSnout(compound.m_128471_("hasShortSnout"));
        this.setHump(compound.m_128471_("hasHump"));
    }
}

