/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Path;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.util.EntityUtils;

public class EntityTriggerfish
extends ComplexMobAquatic
implements ISpecies,
INewSkins {
    public EntityTriggerfish(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.8, false, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TriggerFishBlowGoal(this, 600));
        this.f_21345_.m_25352_(4, (Goal)new ComplexMobAquatic.SwimGoal(this, 5));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.m_9236_().m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            this.setAngry(this.m_5448_() != null);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && itemstack.m_41720_().equals(Items.f_42447_) && this.m_6084_()) {
            EntityUtils.mutateEntityIntoItem((LivingEntity)this, player, hand, "bucket_triggerfish", itemstack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.m_9236_().m_45976_(EntityTriggerfish.class, this.m_20191_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityTriggerfish)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_triggerfish", this.getOffspring());
        return null;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public class TriggerFishBlowGoal
    extends MoveToBlockGoal {
        private final ComplexMobAquatic taskOwner;
        private final int chance;
        private boolean taskComplete;
        private int counter;

        public TriggerFishBlowGoal(ComplexMobAquatic entityIn, int chance) {
            super((PathfinderMob)entityIn, 1.0, 3, 4);
            this.counter = 0;
            this.taskOwner = entityIn;
            this.chance = chance;
        }

        public boolean m_8036_() {
            super.m_8036_();
            if (this.taskOwner.m_217043_().m_188503_(this.chance) == 0 || this.f_25602_.equals((Object)BlockPos.f_121853_)) {
                this.taskComplete = false;
                return true;
            }
            return false;
        }

        protected void m_25624_() {
            this.f_25598_.m_21573_().m_26519_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 2), (double)this.f_25602_.m_123343_() + 0.5, this.f_25599_);
        }

        protected BlockPos m_6669_() {
            return this.f_25602_.m_6630_(1);
        }

        public boolean m_8045_() {
            return !this.taskComplete;
        }

        public double m_8052_() {
            return 1.8;
        }

        public boolean m_6767_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.counter == 0 && this.m_25625_()) {
                this.taskOwner.m_21563_().m_24946_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5);
                this.taskOwner.m_21573_().m_26573_();
                this.counter = this.taskOwner.m_217043_().m_188503_(40) + 40;
            }
            if (this.counter > 0) {
                --this.counter;
                this.taskOwner.m_21563_().m_24946_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5);
                if (this.counter == 0) {
                    Direction direction = this.taskOwner.m_6374_();
                    this.taskOwner.m_20256_(this.taskOwner.m_20184_().m_82520_((double)direction.m_122429_() * -0.1, 0.1, (double)direction.m_122431_() * -0.1));
                    this.taskOwner.m_21573_().m_26573_();
                    Level worldIn = this.taskOwner.m_9236_();
                    ((ServerLevel)worldIn).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, worldIn.m_8055_(this.f_25602_)), (double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_7494_().m_123342_(), (double)this.f_25602_.m_123343_() + 0.5, 50, 0.0, 0.0, 0.0, (double)0.15f);
                    this.taskComplete = true;
                }
            }
        }

        protected boolean m_6465_(LevelReader p_25619_, BlockPos blockpos) {
            if (this.taskOwner.m_9236_().m_8055_(blockpos).m_204336_(BlockTags.f_13029_) && this.taskOwner.m_9236_().m_6425_(blockpos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_) && EntityTriggerfish.this.f_19796_.m_188503_(2) == 0) {
                Path path = this.f_25598_.m_21573_().m_7864_(blockpos, 1);
                return path != null && path.m_77403_();
            }
            return false;
        }
    }
}

