/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;

public class HuntMobTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;
    private final int threshold;
    private final boolean isCannibal;

    public HuntMobTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean isCannibal, Predicate<LivingEntity> targetSelector) {
        this(creature, classTarget, checkSight, 200, isCannibal, targetSelector);
    }

    public HuntMobTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, int hungerThreshold, boolean isCannibal, Predicate<LivingEntity> targetSelector) {
        super((Mob)creature, checkSight, true);
        this.targetClass = classTarget;
        this.sorter = new Sorter((Entity)creature);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.threshold = hungerThreshold;
        this.isCannibal = isCannibal;
        this.targetEntitySelector = entity -> this.isValidTarget((LivingEntity)entity, targetSelector);
    }

    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        Mob mob;
        ComplexMob cmob;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || (Boolean)ConfigGamerules.attackUndead.get() == false && entity.m_6336_() == MobType.f_21641_ || entity instanceof ComplexMob && !(cmob = (ComplexMob)entity).canBeTargeted() || predicate != null && !predicate.test(entity)) {
            return false;
        }
        if (!this.isCannibal && this.f_26135_.getClass() == entity.getClass() && (mob = this.f_26135_) instanceof ComplexMob) {
            ComplexMob attacker = (ComplexMob)mob;
            ComplexMob defender = (ComplexMob)entity;
            if (attacker.getVariant() == defender.getVariant()) {
                return false;
            }
        }
        return this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    public boolean m_8036_() {
        List list;
        if (this.f_26135_.m_6162_() || this.f_26135_.m_21223_() < this.f_26135_.m_21233_() / 3.0f) {
            return false;
        }
        if (this.f_26135_ instanceof ComplexMob) {
            ComplexMobTerrestrial tamed;
            if (((ComplexMob)this.f_26135_).huntingCooldown != 0) {
                return false;
            }
            Mob mob = this.f_26135_;
            if (mob instanceof ComplexMobTerrestrial && ((tamed = (ComplexMobTerrestrial)mob).m_21824_() || tamed.getHunger() > this.threshold)) {
                return false;
            }
        }
        if ((list = this.f_26135_.m_9236_().m_6443_(this.targetClass, this.getTargettableArea(this.m_7623_()), this.targetEntitySelector)).isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.f_26137_ = (LivingEntity)list.get(0);
        return true;
    }

    AABB getTargettableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        if (!this.f_26135_.m_21573_().m_26571_()) {
            this.f_26135_.m_21573_().m_26573_();
        }
        if (this.f_26135_ instanceof ComplexMob) {
            ((ComplexMob)this.f_26135_).huntingCooldown = 6000;
        }
        this.f_26135_.m_6710_(this.f_26137_);
        super.m_8056_();
    }

    public boolean m_8045_() {
        return super.m_8045_();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.m_20280_(entity_1);
            if (dist_1 < (dist_2 = this.entity.m_20280_(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

