/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.phys.AABB;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.mammal.EntityCamel;

public class BeAnAssTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public BeAnAssTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight) {
        super((Mob)creature, checkSight, true);
        this.targetClass = classTarget;
        this.sorter = new Sorter((Entity)creature);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetEntitySelector = entity -> {
            if (entity instanceof Creeper || ComplexMob.getEcoLevel(entity) > ComplexMob.getEcoLevel((LivingEntity)this.f_26135_)) {
                return false;
            }
            if (this.f_26135_.getClass() == entity.getClass() && this.f_26135_ instanceof ISpecies && entity instanceof ISpecies) {
                ComplexMob attacker = (ComplexMob)this.f_26135_;
                ComplexMob defender = (ComplexMob)((Object)entity);
                if (attacker.getVariant() == defender.getVariant()) {
                    return false;
                }
            }
            return this.m_26150_((LivingEntity)entity, TargetingConditions.f_26872_);
        };
    }

    public boolean m_8036_() {
        ComplexMob complexMob;
        if (!(this.f_26135_ instanceof RangedAttackMob)) {
            UntamedWilds.LOGGER.warn("Trying to run BeAnAssTarget Goal on a mob without a ranged attack");
            return false;
        }
        if (this.f_26135_.m_217043_().m_188503_(200) != 0 || this.f_26135_.m_6162_() || this.f_26135_.m_21223_() < this.f_26135_.m_21233_() / 2.0f) {
            return false;
        }
        Mob mob = this.f_26135_;
        if (mob instanceof ComplexMob && (complexMob = (ComplexMob)mob).m_21824_()) {
            return false;
        }
        List list = this.f_26135_.m_9236_().m_6443_(this.targetClass, this.getTargetableArea(this.m_7623_()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetEntity = (LivingEntity)list.get(0);
        if (this.f_26135_ instanceof ComplexMob) {
            ((ComplexMob)this.f_26135_).huntingCooldown = 6000;
        }
        return true;
    }

    AABB getTargetableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        this.f_26135_.m_21563_().m_148051_(this.targetEntity);
        Mob mob = this.f_26135_;
        if (mob instanceof EntityCamel) {
            EntityCamel camel = (EntityCamel)mob;
            camel.m_6504_((LivingEntity)this.targetEntity, 0.5f);
        }
        super.m_8056_();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.m_20280_(entity_1);
            if (dist_1 < (dist_2 = this.entity.m_20280_(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

