/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LardBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public LardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
        if (!worldIn.f_46443_) {
            worldIn.m_7605_(entityIn, (byte)54);
        }
        if (entityIn.m_142535_(fallDistance, 0.2f, entityIn.m_269291_().m_268989_())) {
            entityIn.m_5496_(this.f_60446_.m_56779_(), this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
        }
    }

    public void m_5548_(BlockGetter getter, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(getter, entityIn);
        } else {
            this.bounceUp(entityIn);
        }
    }

    private void bounceUp(Entity p_56404_) {
        Vec3 vec3 = p_56404_.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = p_56404_ instanceof LivingEntity ? 1.0 : 0.8;
            p_56404_.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (this.isSlidingDown(pos, entityIn)) {
            this.doSlideMovement(entityIn);
            LardBlock.showSlideParticles(entityIn, worldIn, pos);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    private void doSlideMovement(Entity entityIn) {
        Vec3 vec3 = entityIn.m_20184_();
        if (vec3.f_82480_ < -0.13) {
            double d0 = -0.05 / vec3.f_82480_;
            entityIn.m_20256_(new Vec3(vec3.f_82479_ * d0, -0.05, vec3.f_82481_ * d0));
        } else {
            entityIn.m_20256_(new Vec3(vec3.f_82479_, -0.05, vec3.f_82481_));
        }
        entityIn.m_183634_();
    }

    private boolean isSlidingDown(BlockPos p_54008_, Entity p_54009_) {
        if (p_54009_.m_20096_()) {
            return false;
        }
        if (p_54009_.m_20186_() > (double)p_54008_.m_123342_() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (p_54009_.m_20184_().f_82480_ >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)p_54008_.m_123341_() + 0.5 - p_54009_.m_20185_());
        double d1 = Math.abs((double)p_54008_.m_123343_() + 0.5 - p_54009_.m_20189_());
        double d2 = 0.4375 + (double)(p_54009_.m_20205_() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    public static void showSlideParticles(Entity entity, Level world, BlockPos pos) {
        LardBlock.showParticles(entity, world, pos, 5);
    }

    public static void showJumpParticles(Entity entity, Level world, BlockPos pos) {
        LardBlock.showParticles(entity, world, pos, 10);
    }

    private static void showParticles(Entity entity, Level world, BlockPos pos, int p_53990_) {
        if (entity.m_9236_().f_46443_) {
            BlockState blockstate = world.m_8055_(pos);
            for (int i = 0; i < p_53990_; ++i) {
                entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

