/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;

public class CritterBurrowBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public CritterBurrowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.UP).m_83281_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (!this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            worldIn.m_46961_(currentPos, false);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CritterBurrowBlockEntity(pos, state);
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return 10 + randomSource.m_188503_(10);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CritterBurrowBlockEntity) {
            CritterBurrowBlockEntity burrow = (CritterBurrowBlockEntity)blockEntity;
            burrow.releaseOrCreateMob(worldIn);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (worldIn.f_46443_ || hand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResult.FAIL;
        }
        CritterBurrowBlockEntity te = (CritterBurrowBlockEntity)worldIn.m_7702_(pos);
        if (playerIn.m_7500_() && te != null) {
            if (playerIn.m_20161_()) {
                te.releaseOrCreateMob((ServerLevel)worldIn);
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)("This burrow contains " + te.getEntityType().m_20675_())).m_130940_(ChatFormatting.ITALIC));
                playerIn.m_213846_((Component)Component.m_237115_((String)("The variant is " + te.getVariant())).m_130940_(ChatFormatting.ITALIC));
                playerIn.m_213846_((Component)Component.m_237115_((String)("There are " + (te.getInhabitants().size() + te.getCount()) + " mobs inside the burrow (" + te.getInhabitants().size() + " stored, and " + te.getCount() + " to be spawned)")).m_130940_(ChatFormatting.ITALIC));
            }
        } else {
            playerIn.m_213846_((Component)Component.m_237110_((String)"block.burrow.state", (Object[])new Object[]{te.getEntityType().m_20676_().getString()}));
        }
        return InteractionResult.SUCCESS;
    }
}

