/*
 * Decompiled with CFR 0.152.
 */
package cloudmeow.untameddelight.block;

import cloudmeow.untameddelight.registry.UDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SteamedKingCrabBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)3);
    protected static final VoxelShape PLATE_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0, (double)17.0), Block.m_49796_((double)0.0, (double)1.0, (double)-1.0, (double)17.0, (double)4.0, (double)0.0), Block.m_49796_((double)-1.0, (double)1.0, (double)-1.0, (double)0.0, (double)4.0, (double)16.0), Block.m_49796_((double)16.0, (double)1.0, (double)0.0, (double)17.0, (double)4.0, (double)17.0)});
    protected static final VoxelShape CRAB_WEST = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)5.0, (double)3.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape CRAB_EAST = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)11.0, (double)7.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape CRAB_NORTH = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)5.0, (double)12.0, (double)7.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape CRAB_SOUTH = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)7.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);

    public SteamedKingCrabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 3;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)SERVINGS) > 1) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    return CRAB_NORTH;
                }
                case SOUTH: {
                    return CRAB_SOUTH;
                }
                case WEST: {
                    return CRAB_WEST;
                }
                case EAST: {
                    return CRAB_EAST;
                }
            }
        }
        return PLATE_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        ItemStack heldStack = player.m_21120_(handIn);
        if (heldStack.m_150930_(Items.f_42399_)) {
            if (servings == 3) {
                return this.takeServing(level, pos, state, player, handIn, (Item)UDItems.STEAMED_KING_CRAB_LEGS.get());
            }
            if (servings == 2) {
                return this.takeServing(level, pos, state, player, handIn, (Item)UDItems.STEAMED_KING_CRAB.get());
            }
            if (servings == 1) {
                return this.takeServing(level, pos, state, player, handIn, (Item)UDItems.STEAMED_EGG_WITH_KING_CRAB_ROE.get());
            }
        }
        if (servings == 0) {
            level.m_5594_(null, pos, SoundEvents.f_12630_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_46961_(pos, true);
        } else {
            player.m_5661_((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{new ItemStack((ItemLike)Items.f_42399_).m_41786_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, Item serving) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        ItemStack heldItem = player.m_21120_(handIn);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)serving))) {
            player.m_36176_(new ItemStack((ItemLike)serving), false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }
}

