/*
 * Decompiled with CFR 0.152.
 */
package cloudmeow.untameddelight.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class DonerKebabBlock
extends FeastBlock {
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)5);
    protected static final VoxelShape IRON_BAR = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)32.0, (double)9.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0));
    protected static final VoxelShape MEAT_SHAPE = Shapes.m_83148_((VoxelShape)IRON_BAR, (VoxelShape)Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)27.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);

    public DonerKebabBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    public int getMaxServings() {
        return 5;
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    protected InteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings == 0) {
            level.m_5594_((Player)null, pos, SoundEvents.f_12630_, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.m_46961_(pos, true);
            return InteractionResult.SUCCESS;
        }
        ItemStack serving = this.getServingItem(state);
        ItemStack heldStack = player.m_21120_(hand);
        if (servings > 0) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.m_150110_().f_35937_ && serving.hasCraftingRemainingItem()) {
                    heldStack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(serving)) {
                    player.m_36176_(serving, false);
                }
                if ((Integer)level.m_8055_(pos).m_61143_((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.m_7471_(pos, false);
                }
                level.m_5594_((Player)null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"untameddelight.block.kebab.use_container"), true);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)SERVINGS) == 0 ? IRON_BAR : MEAT_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }
}

