/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import io.github.jaredmdobson.concentus.OpusDecoder;
import io.github.jaredmdobson.concentus.OpusException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.opus.OpusAudioData;
import org.gagravarr.opus.OpusFile;

@OnlyIn(value=Dist.CLIENT)
public final class OpusDecoderUtil {
    private static final int MAX_FRAME_SIZE = 60;

    public static Pair<AudioFormat, byte[]> decode(byte[] data) throws IOException, OpusException {
        try (OpusFile opusFile = new OpusFile(new OggFile((InputStream)new ByteArrayInputStream(data)));){
            Pair pair;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                OpusAudioData packet;
                int sampleRate = opusFile.getInfo().getSampleRate();
                int channels = opusFile.getInfo().getNumChannels();
                int frameSize = sampleRate * 60 / 1000;
                OpusDecoder decoder = new OpusDecoder(sampleRate, channels);
                byte[] pcmBytes = new byte[sampleRate * channels * 2];
                while ((packet = opusFile.getNextAudioPacket()) != null) {
                    byte[] packetBytes = packet.getData();
                    int packetLength = packetBytes.length;
                    int samplesDecoded = decoder.decode(packetBytes, 0, packetLength, pcmBytes, 0, frameSize, false);
                    outputStream.write(pcmBytes, 0, samplesDecoded * channels * 2);
                }
                byte[] outputData = outputStream.toByteArray();
                AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, channels, channels * 2, sampleRate, false);
                pair = Pair.of((Object)audioFormat, (Object)outputData);
            }
            return pair;
        }
    }
}

