/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class MaidFluidRender {
    private static final int TEXTURE_SIZE = 16;

    public static Component getFluidName(String fluidId, int amount) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId));
        if (amount <= 0 || fluid == null || fluid.m_6212_(Fluids.f_76191_)) {
            return Component.m_237115_((String)"tooltips.touhou_little_maid.tank_backpack.empty_fluid");
        }
        return fluid.getFluidType().getDescription();
    }

    public static void drawFluid(GuiGraphics graphics, int x, int y, int width, int height, String fluidId, int amount, int capacity) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId));
        if (amount <= 0 || fluid == null || fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        FluidStack fluidStack = new FluidStack(fluid, amount);
        MaidFluidRender.getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = MaidFluidRender.getColorTint(fluidStack);
            int scaledAmount = amount * height / capacity;
            if (scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > height) {
                scaledAmount = height;
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            MaidFluidRender.drawTiledSprite(graphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
            graphics.m_280168_().m_85849_();
        });
    }

    private static Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        return Optional.of(sprite).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_());
    }

    private static int getColorTint(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(fluidStack);
    }

    private static void drawTiledSprite(GuiGraphics guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        MaidFluidRender.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    MaidFluidRender.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tesselator.m_85914_();
    }
}

